/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpinSlider
extends JPanel {
    private JSlider slider;
    private JSpinner spinner;
    private int max;
    private int min;

    public SpinSlider(int min, int max, int step, int tick_spacing) {
        this.max = max;
        this.min = min;
        this.slider = new JSlider(min, max);
        this.slider.setMajorTickSpacing(tick_spacing);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        SpinnerNumberModel model = new SpinnerNumberModel((min + max) / 2, min, max, step);
        this.spinner = new JSpinner(model);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SpinSlider.this.sliderChanged();
            }
        });
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SpinSlider.this.spinnerChanged();
            }
        });
        BoxLayout layout = new BoxLayout(this, 0);
        this.setLayout(layout);
        this.spinner.setMaximumSize(this.spinner.getPreferredSize());
        this.add(this.spinner);
        this.add(this.slider);
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public void setValue(int value) {
        if (value > this.max) {
            value = this.max;
        } else if (value < this.min) {
            value = this.min;
        }
        this.slider.setValue(value);
    }

    protected void sliderChanged() {
        int value = this.slider.getValue();
        if (this.spinner.getValue() != new Integer(value)) {
            this.spinner.setValue(value);
        }
    }

    protected void spinnerChanged() {
        if (this.spinner.getModel() instanceof SpinnerNumberModel) {
            SpinnerNumberModel model = (SpinnerNumberModel)this.spinner.getModel();
            int value = model.getNumber().intValue();
            if (this.slider.getValue() != value) {
                this.slider.setValue(value);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.slider.setEnabled(enabled);
        this.spinner.setEnabled(enabled);
    }
}

