/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.sound.midi.Instrument;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ReconnaissanceIntervallesIHM
extends JPanel
implements SerieIntervallesControleur {
    private ReconnaissanceIntervalles reconnaissance_intervalles;
    private SolfegeIHM ihm;
    private JComboBox cmb_style;
    private JComboBox cmb_arpege;
    private JComboBox cmb_notes_gardees;
    private SpinSlider spn_tps_gardees;
    private JCheckBox chk_sauts_octave;
    private SpinSlider spn_nb_intervalles;
    private SpinSlider spn_tps_intermediaire;
    private JComboBox cmb_instruments;
    private JButton btn_demarrer;
    private Console console;
    private int etat;
    private static final int ETAT_ATTENTE = 0;
    private static final int ETAT_LECTURE = 1;
    private static final String[] str_styles = new String[]{"Plaqu\u00e9", "Arp\u00e9g\u00e9", "Al\u00e9atoire"};
    private static final int STYLE_PLAQUE = 0;
    private static final int STYLE_ARPEGE = 1;
    private static final int STYLE_ALEATOIRE = 2;
    private static final int[] correspondance_style;
    private static final String[] str_arpege;
    private static final int ARPEGE_MONTANT = 0;
    private static final int ARPEGE_DESCENDANT = 1;
    private static final int ARPEGE_ALEATOIRE = 2;
    private static final int[] correspondance_arpege;
    private static final String[] str_notes_gardees;
    private static final int NOTES_GARDEES = 0;
    private static final int NOTES_PIQUEES = 1;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 4;
        correspondance_style = nArray;
        str_arpege = new String[]{"Montant", "Descendant", "Al\u00e9atoire"};
        correspondance_arpege = new int[]{2, 3, 5};
        str_notes_gardees = new String[]{"Gard\u00e9es", "Piqu\u00e9es"};
    }

    public ReconnaissanceIntervallesIHM(SolfegeIHM ihm, ReconnaissanceIntervalles reconnaissance_intervalles) {
        this.ihm = ihm;
        this.etat = 0;
        this.reconnaissance_intervalles = reconnaissance_intervalles;
        reconnaissance_intervalles.ajouterControleur(this);
        this.console = new Console(ihm);
        this.console.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ReconnaissanceIntervallesIHM.this.consoleClosed();
            }
        });
        this.cmb_style = new JComboBox<String>(str_styles);
        this.cmb_style.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReconnaissanceIntervallesIHM.this.styleChanged();
            }
        });
        this.cmb_arpege = new JComboBox<String>(str_arpege);
        this.cmb_notes_gardees = new JComboBox<String>(str_notes_gardees);
        this.cmb_notes_gardees.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReconnaissanceIntervallesIHM.this.notesGardeesChanged();
            }
        });
        this.spn_tps_gardees = new SpinSlider(100, 1000, 10, 300);
        this.chk_sauts_octave = new JCheckBox("Autoriser les sauts d'octave");
        this.spn_nb_intervalles = new SpinSlider(1, 10, 1, 3);
        this.spn_tps_intermediaire = new SpinSlider(1, 5, 1, 1);
        this.cmb_instruments = new JComboBox<Instrument>(LecteurPartition.getInstruments());
        this.btn_demarrer = new JButton("D\u00e9marrer le test");
        this.btn_demarrer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReconnaissanceIntervallesIHM.this.demarrerClicked();
            }
        });
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        Box box_style = new Box(0);
        box_style.add(new JLabel("Style : "));
        this.cmb_style.setMaximumSize(this.cmb_style.getPreferredSize());
        box_style.add(this.cmb_style);
        box_style.add(new JLabel("Arp\u00e9g\u00e9 : "));
        this.cmb_arpege.setMaximumSize(this.cmb_arpege.getPreferredSize());
        box_style.add(this.cmb_arpege);
        this.add(box_style);
        Box box_notes = new Box(0);
        box_notes.add(new JLabel("Notes : "));
        this.cmb_notes_gardees.setMaximumSize(this.cmb_notes_gardees.getPreferredSize());
        box_notes.add(this.cmb_notes_gardees);
        box_notes.add(new JLabel("Gard\u00e9es (ms) : "));
        box_notes.add(this.spn_tps_gardees);
        this.add(box_notes);
        Box box_sauts = new Box(0);
        box_sauts.add(this.chk_sauts_octave);
        this.add(box_sauts);
        Box box_lecture = new Box(0);
        box_lecture.add(new JLabel("Nombre d'intervalles par s\u00e9rie : "));
        box_lecture.add(this.spn_nb_intervalles);
        this.add(box_lecture);
        Box box_lecture2 = new Box(0);
        box_lecture2.add(new JLabel("Temps entre chaque intervalle (s) : "));
        box_lecture2.add(this.spn_tps_intermediaire);
        this.add(box_lecture2);
        Box box_instruments = new Box(0);
        box_instruments.add(new JLabel("Instrument : "));
        this.cmb_instruments.setMaximumSize(this.cmb_instruments.getPreferredSize());
        box_instruments.add(this.cmb_instruments);
        this.add(box_instruments);
        Box box_btn = new Box(0);
        box_btn.add(this.btn_demarrer);
        this.add(box_btn);
    }

    protected void styleChanged() {
        this.cmb_arpege.setEnabled(this.cmb_style.getSelectedIndex() != 0);
    }

    protected void notesGardeesChanged() {
        this.spn_tps_gardees.setEnabled(this.cmb_notes_gardees.getSelectedIndex() != 1);
    }

    protected void consoleClosed() {
        if (this.etat == 0) {
            return;
        }
        this.reconnaissance_intervalles.arreterLecture();
        int r = JOptionPane.showConfirmDialog(this, "Le test a \u00e9t\u00e9 interrompu. Voulez-vous voir la solution ?", "Solfege", 0, 3);
        if (r == 0) {
            this.afficherSolution();
        }
    }

    protected void demarrerClicked() {
        int nb_intervalles = this.spn_nb_intervalles.getValue();
        int style = correspondance_style[this.cmb_style.getSelectedIndex()];
        int style_arpege = correspondance_arpege[this.cmb_arpege.getSelectedIndex()];
        boolean sauts_octave = this.chk_sauts_octave.isSelected();
        int tps_attente = this.spn_tps_intermediaire.getValue();
        int tps_notes_gardees = this.spn_tps_gardees.getValue();
        if (this.cmb_notes_gardees.getSelectedIndex() == 1) {
            tps_notes_gardees = -1;
        }
        this.console.setVisible(true);
        this.console.ajouterTexte("\nG\u00e9n\u00e9ration de la s\u00e9rie d'intervalles...");
        this.reconnaissance_intervalles.genererSerie(nb_intervalles, style, style_arpege, sauts_octave, tps_attente, tps_notes_gardees);
        this.console.ajouterTexte("OK\n");
        this.lireSerie();
    }

    protected void lireSerie() {
        this.etat = 1;
        Instrument instrument = (Instrument)this.cmb_instruments.getSelectedItem();
        this.reconnaissance_intervalles.jouerSerie(instrument);
    }

    public void signaler(EvenementSerieIntervalles e) {
        switch (e.getType()) {
            case 1: {
                EvenementIntervalleLu ev = (EvenementIntervalleLu)e;
                this.console.ajouterTexte("Lecture de l'intervalle " + ev.getNum() + "/" + ev.getNb() + "\n");
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                this.console.ajouterTexte("Lecture de la s\u00e9rie\n");
                break;
            }
            case 3: {
                Object r;
                this.etat = 0;
                this.console.setVisible(false);
                Object[] actions = new String[]{"Voir la solution", "Refaire le test"};
                do {
                    if ((r = JOptionPane.showInputDialog(this, "Le test est fini, d\u00e9sirez-vous voir la solution, ou refaire le test une nouvelle fois ?", "Solfege", 3, null, actions, actions[0])) == null) continue;
                    if (r.equals(actions[0])) {
                        this.afficherSolution();
                        continue;
                    }
                    if (!r.equals(actions[1])) continue;
                    this.console.setVisible(true);
                    this.lireSerie();
                } while (r != null && r.equals(actions[0]));
                break;
            }
            case -1: {
                JOptionPane.showMessageDialog(this, "Les fonctions MIDI sont indisponibles sur cette machine !", "Solfege - Erreur", 0);
                break;
            }
            default: {
                this.console.ajouterTexte("\u00c9v\u00e8nement : " + e.getType() + "\n");
            }
        }
    }

    public void afficherSolution() {
        DessinSerieIntervallesDialog dessin = new DessinSerieIntervallesDialog((Frame)this.ihm, "Solf\u00e8ge - Solution", true, this.reconnaissance_intervalles.getSerie());
        dessin.setVisible(true);
    }

    public void loadPreferences(Preferences preferences) {
        this.cmb_style.setSelectedIndex(preferences.getInt("style", 0));
        this.cmb_arpege.setSelectedIndex(preferences.getInt("arpege", 0));
        this.cmb_notes_gardees.setSelectedIndex(preferences.getInt("notes_gardees", 0));
        this.spn_tps_gardees.setValue(preferences.getInt("tps_gardees", 500));
        this.chk_sauts_octave.setSelected(preferences.getBoolean("sauts_octave", false));
        this.spn_nb_intervalles.setValue(preferences.getInt("nb_intervalles", 5));
        this.spn_tps_intermediaire.setValue(preferences.getInt("tps_intermediaire", 2));
        this.cmb_instruments.setSelectedIndex(preferences.getInt("instrument_index", 0));
    }

    public void savePreferences(Preferences preferences) {
        preferences.putInt("style", this.cmb_style.getSelectedIndex());
        preferences.putInt("arpege", this.cmb_arpege.getSelectedIndex());
        preferences.putInt("notes_gardees", this.cmb_notes_gardees.getSelectedIndex());
        preferences.putInt("tps_gardees", this.spn_tps_gardees.getValue());
        preferences.putBoolean("sauts_octave", this.chk_sauts_octave.isSelected());
        preferences.putInt("nb_intervalles", this.spn_nb_intervalles.getValue());
        preferences.putInt("tps_intermediaire", this.spn_tps_intermediaire.getValue());
        preferences.putInt("instrument_index", this.cmb_instruments.getSelectedIndex());
    }
}

