/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import javax.sound.midi.Instrument;

public class ReconnaissanceIntervalles
implements SerieIntervallesControleur {
    private ArrayList<SerieIntervallesControleur> controleurs = new ArrayList();
    private LecteurSerieIntervalles lecteur = new LecteurSerieIntervalles();
    private SerieIntervalles serie = null;

    public ReconnaissanceIntervalles() {
        this.lecteur.ajouterControleur(this);
    }

    public void genererSerie(int nb, int style, int style_arpege, boolean sauts_octave, int tps_attente, int tps_notes_gardees) {
        Intervalle[] intervalles = new Intervalle[nb];
        int i = 0;
        while (i < nb) {
            intervalles[i] = Intervalle.intervalleAleatoire(style, style_arpege, sauts_octave);
            ++i;
        }
        this.serie = new SerieIntervalles(intervalles, tps_attente, tps_notes_gardees);
    }

    public SerieIntervalles getSerie() {
        return this.serie;
    }

    public void jouerSerie(Instrument instrument) {
        if (this.serie == null) {
            return;
        }
        this.lecteur.charger(this.serie);
        this.lecteur.lire(instrument);
    }

    public void arreterLecture() {
        this.lecteur.arreter();
    }

    public void ajouterControleur(SerieIntervallesControleur c) {
        this.controleurs.add(c);
    }

    public void signaler(EvenementSerieIntervalles e) {
        for (SerieIntervallesControleur controleur : this.controleurs) {
            controleur.signaler(e);
        }
    }
}

