/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.prefs.Preferences;
import javax.sound.midi.Instrument;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ReconnaissanceAccordsIHM
extends JPanel
implements SerieAccordsControleur {
    private Console console;
    private SolfegeIHM ihm;
    private ReconnaissanceAccords reconnaissance_accords;
    private JCheckBox chk_tous_types;
    private JList lst_type;
    private JComboBox cmb_style;
    private JComboBox cmb_arpege;
    private JComboBox cmb_notes_gardees;
    private SpinSlider spn_nb_notes;
    private SpinSlider spn_tps_gardees;
    private SpinSlider spn_nb_accords;
    private SpinSlider spn_tps_intermediaire;
    private JComboBox cmb_instruments;
    private JButton btn_demarrer;
    private static final String[] str_types = new String[]{"Parfait", "Quinte diminu\u00e9e", "Quinte augment\u00e9e", "Septi\u00e8me dominante", "Septi\u00e8me diminu\u00e9e", "Septi\u00e8me d'esp\u00e8ce"};
    private static final int[] correspondance_type = new int[]{1, 16, 32, 2, 4, 8};
    private static final String[] str_styles = new String[]{"Plaqu\u00e9", "Arp\u00e9g\u00e9", "Al\u00e9atoire"};
    private static final int STYLE_PLAQUE = 0;
    private static final int STYLE_ARPEGE = 1;
    private static final int STYLE_ALEATOIRE = 2;
    private static final int[] correspondance_style;
    private static final String[] str_arpege;
    private static final int ARPEGE_MONTANT = 0;
    private static final int ARPEGE_DESCENDANT = 1;
    private static final int ARPEGE_ALEATOIRE = 2;
    private static final int[] correspondance_arpege;
    private static final String[] str_notes_gardees;
    private static final int NOTES_GARDEES = 0;
    private static final int NOTES_PIQUEES = 1;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 4;
        correspondance_style = nArray;
        str_arpege = new String[]{"Montant", "Descendant", "Al\u00e9atoire"};
        correspondance_arpege = new int[]{2, 3, 5};
        str_notes_gardees = new String[]{"Gard\u00e9es", "Piqu\u00e9es"};
    }

    public ReconnaissanceAccordsIHM(SolfegeIHM ihm, ReconnaissanceAccords reconnaissance_accords) {
        this.ihm = ihm;
        this.reconnaissance_accords = reconnaissance_accords;
        reconnaissance_accords.ajouterControleur(this);
        this.console = new Console(ihm);
        this.console.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ReconnaissanceAccordsIHM.this.consoleClosed();
            }
        });
        this.chk_tous_types = new JCheckBox("Tous types d'accord");
        this.chk_tous_types.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReconnaissanceAccordsIHM.this.typeClicked();
            }
        });
        this.lst_type = new JList<String>(str_types);
        this.cmb_style = new JComboBox<String>(str_styles);
        this.cmb_style.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReconnaissanceAccordsIHM.this.styleChanged();
            }
        });
        this.cmb_arpege = new JComboBox<String>(str_arpege);
        this.cmb_notes_gardees = new JComboBox<String>(str_notes_gardees);
        this.cmb_notes_gardees.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReconnaissanceAccordsIHM.this.notesGardeesChanged();
            }
        });
        this.spn_nb_notes = new SpinSlider(3, 10, 1, 1);
        this.spn_tps_gardees = new SpinSlider(1, 10, 1, 1);
        this.spn_nb_accords = new SpinSlider(1, 10, 1, 3);
        this.spn_tps_intermediaire = new SpinSlider(1, 5, 1, 1);
        this.cmb_instruments = new JComboBox<Instrument>(LecteurPartition.getInstruments());
        this.btn_demarrer = new JButton("D\u00e9marrer le test");
        this.btn_demarrer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReconnaissanceAccordsIHM.this.demarrerClicked();
            }
        });
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        Box box_type = new Box(0);
        box_type.add(this.chk_tous_types);
        box_type.add(this.lst_type);
        this.add(box_type);
        Box box_style = new Box(0);
        box_style.add(new JLabel("Style : "));
        this.cmb_style.setMaximumSize(this.cmb_style.getPreferredSize());
        box_style.add(this.cmb_style);
        box_style.add(new JLabel("Arp\u00e9g\u00e9 : "));
        this.cmb_arpege.setMaximumSize(this.cmb_arpege.getPreferredSize());
        box_style.add(this.cmb_arpege);
        this.add(box_style);
        Box box_notes = new Box(0);
        box_notes.add(new JLabel("Notes : "));
        this.cmb_notes_gardees.setMaximumSize(this.cmb_notes_gardees.getPreferredSize());
        box_notes.add(this.cmb_notes_gardees);
        box_notes.add(new JLabel("Gard\u00e9es (s) : "));
        box_notes.add(this.spn_tps_gardees);
        this.add(box_notes);
        Box box_nb_notes = new Box(0);
        box_nb_notes.add(new JLabel("Nombre de notes par accord : "));
        box_nb_notes.add(this.spn_nb_notes);
        this.add(box_nb_notes);
        Box box_lecture = new Box(0);
        box_lecture.add(new JLabel("Nombre d'accords par s\u00e9rie : "));
        box_lecture.add(this.spn_nb_accords);
        this.add(box_lecture);
        Box box_lecture2 = new Box(0);
        box_lecture2.add(new JLabel("Temps entre chaque accord (s) : "));
        box_lecture2.add(this.spn_tps_intermediaire);
        this.add(box_lecture2);
        Box box_instruments = new Box(0);
        box_instruments.add(new JLabel("Instrument : "));
        this.cmb_instruments.setMaximumSize(this.cmb_instruments.getPreferredSize());
        box_instruments.add(this.cmb_instruments);
        this.add(box_instruments);
        Box box_btn = new Box(0);
        box_btn.add(this.btn_demarrer);
        this.add(box_btn);
    }

    protected void typeClicked() {
        this.lst_type.setEnabled(!this.chk_tous_types.isSelected());
    }

    protected void consoleClosed() {
        this.reconnaissance_accords.arreterLecture();
        int r = JOptionPane.showConfirmDialog(this, "Le test a \u00e9t\u00e9 interrompu. Voulez-vous voir la solution ?", "Solfege", 0, 3);
        if (r == 0) {
            this.afficherSolution();
        }
    }

    protected void styleChanged() {
        this.cmb_arpege.setEnabled(this.cmb_style.getSelectedIndex() != 0);
    }

    protected void notesGardeesChanged() {
        this.spn_tps_gardees.setEnabled(this.cmb_notes_gardees.getSelectedIndex() != 1);
    }

    protected void demarrerClicked() {
        int nb_accords = this.spn_nb_accords.getValue();
        int style = correspondance_style[this.cmb_style.getSelectedIndex()];
        int style_arpege = correspondance_arpege[this.cmb_arpege.getSelectedIndex()];
        int types = 0;
        if (this.chk_tous_types.isSelected()) {
            types = 15;
        } else {
            int[] sel;
            int[] nArray = sel = this.lst_type.getSelectedIndices();
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int i = nArray[n];
                types |= correspondance_type[i];
                ++n;
            }
        }
        if (types == 0) {
            JOptionPane.showMessageDialog(this, "Veuillez s\u00e9lectionner au moins un type d'accord", "Solf\u00e8ge - Erreur", 0);
            return;
        }
        int nb_notes = this.spn_nb_notes.getValue();
        int tps_attente = this.spn_tps_intermediaire.getValue();
        int tps_notes_gardees = this.spn_tps_gardees.getValue();
        if (this.cmb_notes_gardees.getSelectedIndex() == 1) {
            tps_notes_gardees = -1;
        }
        this.console.setVisible(true);
        this.console.ajouterTexte("G\u00e9n\u00e9ration de la s\u00e9rie d'accords...");
        this.reconnaissance_accords.genererSerie(nb_accords, tps_attente, tps_notes_gardees, types, style, style_arpege, nb_notes);
        this.console.ajouterTexte("OK\n");
        this.lireSerie();
    }

    protected void lireSerie() {
        Instrument instrument = (Instrument)this.cmb_instruments.getSelectedItem();
        this.reconnaissance_accords.jouerSerie(instrument);
    }

    public void afficherSolution() {
        DessinSerieAccordsDialog dessin = new DessinSerieAccordsDialog((Frame)this.ihm, "Solf\u00e8ge - Solution", true, this.reconnaissance_accords.getSerie());
        dessin.setVisible(true);
    }

    public void signaler(EvenementSerieAccords e) {
        switch (e.getType()) {
            case 1: {
                EvenementAccordLu ev = (EvenementAccordLu)e;
                this.console.ajouterTexte("Lecture de l'accord " + ev.getNum() + "/" + ev.getNb() + "\n");
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                this.console.ajouterTexte("Lecture de la s\u00e9rie\n");
                break;
            }
            case 3: {
                Object r;
                this.console.setVisible(false);
                Object[] actions = new String[]{"Voir la solution", "Refaire le test"};
                do {
                    if ((r = JOptionPane.showInputDialog(this, "Le test est fini, d\u00e9sirez-vous voir la solution, ou refaire le test une nouvelle fois ?", "Solfege", 3, null, actions, actions[0])) == null) continue;
                    if (r.equals(actions[0])) {
                        this.afficherSolution();
                        continue;
                    }
                    if (!r.equals(actions[1])) continue;
                    this.console.setVisible(true);
                    this.lireSerie();
                } while (r != null && r.equals(actions[0]));
                break;
            }
            case -1: {
                JOptionPane.showMessageDialog(this, "Les fonctions MIDI sont indisponibles sur cette machine !", "Solfege - Erreur", 0);
                break;
            }
            default: {
                this.console.ajouterTexte("\u00c9v\u00e8nement : " + e.getType() + "\n");
            }
        }
    }

    public void loadPreferences(Preferences preferences) {
        ByteArrayInputStream stream = new ByteArrayInputStream(preferences.getByteArray("types", new byte[0]));
        try {
            ObjectInputStream object_stream = new ObjectInputStream(stream);
            int[] indices = (int[])object_stream.readObject();
            this.lst_type.setSelectedIndices(indices);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.chk_tous_types.setSelected(preferences.getBoolean("tous_types", true));
        this.cmb_style.setSelectedIndex(preferences.getInt("style", 0));
        this.cmb_arpege.setSelectedIndex(preferences.getInt("arpege", 0));
        this.cmb_notes_gardees.setSelectedIndex(preferences.getInt("notes_gardees", 0));
        this.spn_nb_notes.setValue(preferences.getInt("nb_notes", 5));
        this.spn_tps_gardees.setValue(preferences.getInt("tps_gardees", 3));
        this.spn_nb_accords.setValue(preferences.getInt("nb_accords", 5));
        this.spn_tps_intermediaire.setValue(preferences.getInt("tps_intermediaire", 2));
        this.cmb_instruments.setSelectedIndex(preferences.getInt("instrument_index", 0));
    }

    public void savePreferences(Preferences preferences) {
        preferences.putBoolean("tous_types", this.chk_tous_types.isSelected());
        int[] indices = this.lst_type.getSelectedIndices();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream object_stream = new ObjectOutputStream(stream);
            object_stream.writeObject(indices);
            preferences.putByteArray("types", stream.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        preferences.putInt("style", this.cmb_style.getSelectedIndex());
        preferences.putInt("arpege", this.cmb_arpege.getSelectedIndex());
        preferences.putInt("notes_gardees", this.cmb_notes_gardees.getSelectedIndex());
        preferences.putInt("nb_notes", this.spn_nb_notes.getValue());
        preferences.putInt("tps_gardees", this.spn_tps_gardees.getValue());
        preferences.putInt("nb_accords", this.spn_nb_accords.getValue());
        preferences.putInt("tps_intermediaire", this.spn_tps_intermediaire.getValue());
        preferences.putInt("instrument_index", this.cmb_instruments.getSelectedIndex());
    }
}

