/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Synthesizer;

public class LecteurAgregat
implements Runnable {
    private Instrument instrument;
    private int thread_etat;
    private Thread thread = null;
    private static final int ETAT_MORT = 0;
    private static final int ETAT_EXECUTE = 1;
    private static final int ETAT_SUSPENDU = 2;
    private ArrayList<AgregatControleur> controleurs = new ArrayList();
    private Agregat agregat = null;

    public LecteurAgregat() {
        this.setEtatThread(0);
    }

    public void ajouterControleur(AgregatControleur c) {
        this.controleurs.add(c);
    }

    public void charger(Agregat a) {
        this.agregat = a;
    }

    public void lire(Instrument instrument) {
        if (this.agregat == null) {
            this.signaler(new EvenementAgregat(-2));
            return;
        }
        this.instrument = instrument;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void suspendre() {
        int etat = this.getEtatThread();
        if (etat == 1) {
            this.setEtatThread(2);
        } else if (etat == 2) {
            this.setEtatThread(1);
        }
    }

    public void arreter() {
        this.setEtatThread(0);
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void run() {
        Element note;
        MidiChannel channel;
        Synthesizer synth;
        this.setEtatThread(1);
        try {
            synth = MidiSystem.getSynthesizer();
            synth.open();
            channel = synth.getChannels()[0];
            channel.allSoundOff();
            channel.programChange(this.instrument.getPatch().getBank(), this.instrument.getPatch().getProgram());
        }
        catch (Exception exc) {
            this.signaler(new EvenementAgregat(-1));
            return;
        }
        this.signaler(new EvenementAgregat(2));
        channel.noteOn(69, 63);
        this.attendre(1000);
        if (this.getEtatThread() == 0) {
            synth.close();
            return;
        }
        channel.noteOff(69, 63);
        this.attendre(750);
        if (this.getEtatThread() == 0) {
            synth.close();
            return;
        }
        Element[] notes = this.agregat.getNotes();
        this.signaler(new EvenementAgregat(0));
        Element[] elementArray = notes;
        int n = 0;
        int n2 = elementArray.length;
        while (n < n2) {
            note = elementArray[n];
            channel.noteOn(note.getType() + 36, 63);
            ++n;
        }
        this.attendre(this.agregat.getDuree() * 1000);
        if (this.getEtatThread() == 0) {
            synth.close();
            return;
        }
        elementArray = notes;
        n = 0;
        n2 = elementArray.length;
        while (n < n2) {
            note = elementArray[n];
            channel.noteOff(note.getType() + 36, 63);
            ++n;
        }
        synth.close();
        this.signaler(new EvenementAgregat(1));
    }

    protected void attendre(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void signaler(EvenementAgregat e) {
        for (AgregatControleur controleur : this.controleurs) {
            controleur.signaler(e);
        }
    }

    private synchronized void setEtatThread(int etat) {
        this.thread_etat = etat;
    }

    private synchronized int getEtatThread() {
        return this.thread_etat;
    }
}

