/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class Intervalle {
    private int note1;
    private int note2;
    private int style;
    public static final int STYLE_PLAQUE = 0;
    public static final int STYLE_ARPEGE = 1;
    public static final int STYLE_ARPEGE_MONTANT = 2;
    public static final int STYLE_ARPEGE_DESCENDANT = 3;
    public static final int STYLE_ALEATOIRE = 4;
    public static final int STYLE_ARPEGE_ALEATOIRE = 5;
    public static final String[] str_ecarts = new String[]{"Octave", "Seconde mineure", "Seconde majeure", "Tierce mineure", "Tierce majeure", "Quarte juste", "Quarte augment\u00e9e", "Quinte juste", "Sixte mineure", "Sixte majeure", "Septi\u00e8me mineure", "Septi\u00e8me majeure"};
    public static final int SECONDE_MINEURE = 1;
    public static final int SECONDE_MAJEURE = 2;
    public static final int TIERCE_MINEURE = 3;
    public static final int TIERCE_MAJEURE = 4;
    public static final int QUARTE_JUSTE = 5;
    public static final int QUARTE_AUGMENTEE = 6;
    public static final int QUINTE_JUSTE = 7;
    public static final int SIXTE_MINEURE = 8;
    public static final int SIXTE_MAJEURE = 9;
    public static final int SEPTIEME_MINEURE = 10;
    public static final int SEPTIEME_MAJEURE = 11;
    public static final int OCTAVE = 12;

    public Intervalle(int ecart, int note_base, int style, int style_arpege) {
        Random rand = new Random();
        if (style == 4) {
            style = rand.nextInt(2);
        }
        switch (style) {
            case 1: {
                if (style_arpege == 5) {
                    style_arpege = rand.nextBoolean() ? 2 : 3;
                }
                switch (style_arpege) {
                    case 2: {
                        this.note1 = note_base;
                        this.note2 = note_base + ecart;
                        break;
                    }
                    case 3: {
                        this.note2 = note_base;
                        this.note1 = note_base + ecart;
                    }
                }
                break;
            }
            case 0: {
                this.note1 = note_base;
                this.note2 = note_base + ecart;
            }
        }
        this.style = style;
    }

    public int getEcart() {
        return Math.abs(this.note1 - this.note2);
    }

    public int getNote1() {
        return this.note1;
    }

    public int getNote2() {
        return this.note2;
    }

    public int getStyle() {
        return this.style;
    }

    public String toString() {
        String result = "";
        int ecart = Math.abs(this.note2 - this.note1);
        int nb_octaves = ecart / 12;
        int reste = ecart % 12;
        if (nb_octaves != 0 && reste != 0) {
            result = String.valueOf(result) + nb_octaves + " octave" + (nb_octaves > 1 ? "s" : "") + " + ";
        }
        result = String.valueOf(result) + str_ecarts[reste];
        return result;
    }

    public static Intervalle intervalleAleatoire(int style, int style_arpege, boolean sauts_octave) {
        Random rand = new Random();
        int ecart_max = sauts_octave ? 47 : 12;
        int ecart = rand.nextInt(ecart_max) + 1;
        int note_base = rand.nextInt(48 - ecart);
        return new Intervalle(ecart, note_base, style, style_arpege);
    }
}

