/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Random;
import javax.sound.midi.Instrument;

public class ReconnaissanceAccords
implements SerieAccordsControleur {
    private SerieAccords serie = null;
    private ArrayList<SerieAccordsControleur> controleurs = new ArrayList();
    private LecteurSerieAccords lecteur = new LecteurSerieAccords();
    private static int[] types_mask = new int[]{1, 2, 4, 8, 16, 32};

    public ReconnaissanceAccords() {
        this.lecteur.ajouterControleur(this);
    }

    public void genererSerie(int nb_accords, int tps_attente, int tps_notes_gardees, int types, int style, int style_arpege, int nb_notes) {
        Random rand = new Random();
        int nb_types = 0;
        int[] cur_types_mask = new int[6];
        int[] nArray = types_mask;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int mask = nArray[n];
            if ((types & mask) != 0) {
                cur_types_mask[nb_types++] = mask;
            }
            ++n;
        }
        Accord[] accords = new Accord[nb_accords];
        int i = 0;
        while (i < nb_accords) {
            int type = cur_types_mask[rand.nextInt(nb_types)];
            int basse = Element.noteAleatoire();
            accords[i] = new Accord(type, style, style_arpege, nb_notes, basse);
            ++i;
        }
        this.serie = new SerieAccords(accords, tps_attente, tps_notes_gardees);
    }

    public void jouerSerie(Instrument instrument) {
        if (this.serie == null) {
            return;
        }
        this.lecteur.charger(this.serie);
        this.lecteur.lire(instrument);
    }

    public void arreterLecture() {
        this.lecteur.arreter();
    }

    public SerieAccords getSerie() {
        return this.serie;
    }

    public void ajouterControleur(SerieAccordsControleur controleur) {
        this.controleurs.add(controleur);
    }

    public void signaler(EvenementSerieAccords e) {
        for (SerieAccordsControleur controleur : this.controleurs) {
            controleur.signaler(e);
        }
    }
}

