/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Synthesizer;

public class LecteurSerieIntervalles
implements Runnable {
    private ArrayList<SerieIntervallesControleur> controleurs = new ArrayList();
    SerieIntervalles serie;
    Instrument instrument;
    private int thread_etat;
    private static final int ETAT_MORT = 0;
    private static final int ETAT_EXECUTE = 1;
    private static final int ETAT_SUSPENDU = 2;

    public LecteurSerieIntervalles() {
        this.setEtatThread(0);
    }

    public void charger(SerieIntervalles serie) {
        this.serie = serie;
    }

    public void lire(Instrument instrument) {
        if (this.serie == null) {
            this.signaler(new EvenementSerieIntervalles(-2));
            return;
        }
        this.instrument = instrument;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void suspendre() {
        int etat = this.getEtatThread();
        if (etat == 1) {
            this.setEtatThread(2);
        } else if (etat == 2) {
            this.setEtatThread(1);
        }
    }

    public void arreter() {
        this.setEtatThread(0);
    }

    public void run() {
        MidiChannel channel;
        Synthesizer synth;
        this.setEtatThread(1);
        this.signaler(new EvenementSerieIntervalles(0));
        try {
            synth = MidiSystem.getSynthesizer();
            synth.open();
            channel = synth.getChannels()[0];
            channel.allSoundOff();
            channel.programChange(this.instrument.getPatch().getBank(), this.instrument.getPatch().getProgram());
        }
        catch (Exception exc) {
            this.signaler(new EvenementSerieIntervalles(-1));
            return;
        }
        int num_intervalle = 0;
        Intervalle[] intervalles = this.serie.getIntervalles();
        int tps_notes_gardees = this.serie.getTpsNotesGardees();
        if (tps_notes_gardees == -1) {
            tps_notes_gardees = 50;
        }
        while (this.getEtatThread() != 0 && num_intervalle < intervalles.length) {
            Intervalle intervalle = intervalles[num_intervalle];
            this.signaler(new EvenementIntervalleLu(num_intervalle + 1, intervalles.length));
            switch (intervalle.getStyle()) {
                case 0: {
                    channel.noteOn(intervalle.getNote1() + 36, 63);
                    channel.noteOn(intervalle.getNote2() + 36, 63);
                    try {
                        Thread.sleep(tps_notes_gardees);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    channel.noteOff(intervalle.getNote1() + 36, 63);
                    channel.noteOff(intervalle.getNote2() + 36, 63);
                    break;
                }
                case 1: {
                    channel.noteOn(intervalle.getNote1() + 36, 63);
                    try {
                        Thread.sleep(tps_notes_gardees);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    channel.noteOff(intervalle.getNote1() + 36, 63);
                    channel.noteOn(intervalle.getNote2() + 36, 63);
                    try {
                        Thread.sleep(tps_notes_gardees);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    channel.noteOff(intervalle.getNote2() + 36, 63);
                }
            }
            this.signaler(new EvenementSerieIntervalles(2));
            try {
                Thread.sleep(this.serie.getTpsAttente() * 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++num_intervalle;
        }
        synth.close();
        if (num_intervalle == intervalles.length) {
            this.signaler(new EvenementSerieIntervalles(3));
        }
    }

    protected void signaler(EvenementSerieIntervalles e) {
        for (SerieIntervallesControleur controleur : this.controleurs) {
            controleur.signaler(e);
        }
    }

    public void ajouterControleur(SerieIntervallesControleur controleur) {
        this.controleurs.add(controleur);
    }

    private synchronized void setEtatThread(int etat) {
        this.thread_etat = etat;
    }

    private synchronized int getEtatThread() {
        return this.thread_etat;
    }
}

