/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Synthesizer;

public class LecteurSerieAccords
implements Runnable {
    private ArrayList<SerieAccordsControleur> controleurs = new ArrayList();
    private SerieAccords serie = null;
    private Instrument instrument;
    private int thread_etat;
    private static final int ETAT_MORT = 0;
    private static final int ETAT_EXECUTE = 1;
    private static final int ETAT_SUSPENDU = 2;

    public void charger(SerieAccords serie) {
        this.serie = serie;
    }

    public void lire(Instrument instrument) {
        if (this.serie == null) {
            this.signaler(new EvenementSerieAccords(-2));
            return;
        }
        this.instrument = instrument;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void suspendre() {
        int etat = this.getEtatThread();
        if (etat == 1) {
            this.setEtatThread(2);
        } else if (etat == 2) {
            this.setEtatThread(1);
        }
    }

    public void arreter() {
        this.setEtatThread(0);
    }

    public void run() {
        MidiChannel channel;
        Synthesizer synth;
        this.setEtatThread(1);
        this.signaler(new EvenementSerieAccords(0));
        try {
            synth = MidiSystem.getSynthesizer();
            synth.open();
            channel = synth.getChannels()[0];
            channel.allSoundOff();
            channel.programChange(this.instrument.getPatch().getBank(), this.instrument.getPatch().getProgram());
        }
        catch (Exception exc) {
            this.signaler(new EvenementSerieAccords(-1));
            return;
        }
        int num_accord = 0;
        Accord[] accords = this.serie.getAccords();
        int tps_notes_gardees = this.serie.getTpsNotesGardees();
        if (tps_notes_gardees == -1) {
            tps_notes_gardees = 1;
        }
        while (this.getEtatThread() != 0 && num_accord < accords.length) {
            Accord accord = accords[num_accord];
            this.signaler(new EvenementAccordLu(num_accord + 1, accords.length));
            int[] notes = accord.getNotes();
            int i = 0;
            switch (accord.getStyle()) {
                case 2: 
                case 3: {
                    while (this.getEtatThread() != 0 && i < notes.length) {
                        channel.noteOn(notes[i] + 36, 63);
                        try {
                            Thread.sleep(tps_notes_gardees * 1000);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        channel.noteOff(notes[i] + 36, 63);
                        ++i;
                    }
                    break;
                }
                case 0: {
                    while (this.getEtatThread() != 0 && i < notes.length) {
                        channel.noteOn(notes[i] + 36, 63);
                        ++i;
                    }
                    try {
                        Thread.sleep(tps_notes_gardees * 1000);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    channel.allNotesOff();
                }
            }
            this.signaler(new EvenementSerieAccords(2));
            try {
                Thread.sleep(this.serie.getTpsAttente() * 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++num_accord;
        }
        synth.close();
        if (num_accord == accords.length) {
            this.signaler(new EvenementSerieAccords(3));
        }
    }

    public void ajouterControleur(SerieAccordsControleur controleur) {
        this.controleurs.add(controleur);
    }

    protected void signaler(EvenementSerieAccords e) {
        for (SerieAccordsControleur controleur : this.controleurs) {
            controleur.signaler(e);
        }
    }

    private synchronized void setEtatThread(int etat) {
        this.thread_etat = etat;
    }

    private synchronized int getEtatThread() {
        return this.thread_etat;
    }
}

