/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;

public class LecteurPartition
implements Runnable {
    private Partition partition;
    private Instrument instrument = null;
    private int tempo = 60;
    private Thread thread = null;
    int thread_etat;
    private static final int ETAT_MORT = 0;
    private static final int ETAT_EXECUTE = 1;
    private static final int ETAT_SUSPENDU = 2;
    private ArrayList<MusiqueControleur> controleurs = new ArrayList();

    public void charger(Partition partition) {
        this.partition = partition;
    }

    public void lire(Instrument instrument, int tempo) {
        if (this.partition == null) {
            this.signaler(new EvenementMusique(2));
            return;
        }
        this.instrument = instrument;
        this.tempo = tempo;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void suspendre() {
        if (this.getEtatThread() == 2) {
            this.setEtatThread(1);
        } else {
            this.setEtatThread(2);
        }
    }

    public void arreter() {
        this.setEtatThread(0);
    }

    private synchronized void setEtatThread(int etat) {
        this.thread_etat = etat;
    }

    private synchronized int getEtatThread() {
        return this.thread_etat;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.setEtatThread(1);
        try {
            synth = MidiSystem.getSynthesizer();
            synth.open();
            channel = synth.getChannels()[0];
            channel.allSoundOff();
            channel.programChange(this.instrument.getPatch().getBank(), this.instrument.getPatch().getProgram());
        }
        catch (Exception exc) {
            this.signaler(new EvenementMidiIndisponible());
            return;
        }
        nb_voies = this.partition.getNbVoies();
        nb_voies_finies = 0;
        voies = new Voie.Iterateur[nb_voies];
        v = this.partition.getVoies();
        temps = 0;
        i = 0;
        while (i < nb_voies) {
            voies[i] = v[i].iterateur();
            ++i;
        }
        this.signaler(new EvenementMusique(6));
        do {
            i = 0;
            while (i < nb_voies) {
                block12: {
                    if (!voies[i].elementDisponible()) break block12;
                    e = voies[i].elementCourant();
                    if (e.getPosition() + e.getDuree() != temps) ** GOTO lbl-1000
                    if (e.getType() != -1) {
                        channel.noteOff(e.getType() + 36, 63);
                    }
                    voies[i].elementSuivant();
                    if (!voies[i].elementDisponible()) {
                        ++nb_voies_finies;
                    } else if ((e = voies[i].elementCourant()).getPosition() == temps && e.getType() != -1) {
                        channel.noteOn(e.getType() + 36, 63);
                    }
                }
                ++i;
            }
            ++temps;
            try {
                Thread.sleep(60000 / (this.tempo * 4));
            }
            catch (InterruptedException var8_10) {
                // empty catch block
            }
        } while (nb_voies_finies < nb_voies && this.getEtatThread() == 1);
        synth.close();
        if (nb_voies_finies == nb_voies) {
            this.signaler(new EvenementMusique(0));
        }
    }

    public static Instrument[] getInstruments() {
        try {
            Synthesizer s = MidiSystem.getSynthesizer();
            s.open();
            return s.getAvailableInstruments();
        }
        catch (MidiUnavailableException e) {
            return new Instrument[0];
        }
    }

    protected void signaler(EvenementMusique e) {
        for (MusiqueControleur controleur : this.controleurs) {
            controleur.signaler(e);
        }
    }

    public void ajouterControleur(MusiqueControleur controleur) {
        this.controleurs.add(controleur);
    }
}

