/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.sound.midi.Instrument;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class DicteeNotesIHM
extends JPanel
implements MusiqueControleur {
    private SolfegeIHM ihm;
    private Console console;
    private DicteeNotes dictee_notes;
    private SpinSlider slider_longueur;
    private SpinSlider slider_nbvoies;
    private JCheckBox checkbox_sauts_octave;
    private SpinSlider slider_tempo;
    private JSpinner spinner_nb_lectures;
    private JComboBox combobox_instruments;
    private int etat;
    private static final int ATTENTE = 0;
    private static final int LECTURE_LA = 1;
    private static final int LECTURE_DICTEE = 2;
    private int nb_lectures;

    public DicteeNotesIHM(SolfegeIHM ihm, DicteeNotes dictee_notes) {
        this.ihm = ihm;
        this.dictee_notes = dictee_notes;
        this.console = new Console(ihm);
        this.console.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DicteeNotesIHM.this.interrompreDictee();
            }
        });
        this.etat = 0;
        this.nb_lectures = 0;
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        Box box_longueur = new Box(0);
        box_longueur.add(new JLabel("Nombre de notes : "));
        this.slider_longueur = new SpinSlider(0, 30, 1, 5);
        box_longueur.add(this.slider_longueur);
        this.add(box_longueur);
        Box box_nbvoies = new Box(0);
        box_nbvoies.add(new JLabel("Nombre de voies : "));
        this.slider_nbvoies = new SpinSlider(1, 5, 1, 1);
        this.slider_nbvoies.setValue(1);
        box_nbvoies.add(this.slider_nbvoies);
        this.add(box_nbvoies);
        Box box_sauts_octave = new Box(0);
        this.checkbox_sauts_octave = new JCheckBox("Autoriser les sauts d'octave");
        box_sauts_octave.add(this.checkbox_sauts_octave);
        this.add(box_sauts_octave);
        Box box_tempo = new Box(0);
        box_tempo.add(new JLabel("Tempo (bpm) : "));
        this.slider_tempo = new SpinSlider(30, 120, 1, 10);
        box_tempo.add(this.slider_tempo);
        this.add(box_tempo);
        Box box_nb_lectures = new Box(0);
        box_nb_lectures.add(new JLabel("Nombre de lectures : "));
        SpinnerNumberModel model = new SpinnerNumberModel(2, 1, 10, 1);
        this.spinner_nb_lectures = new JSpinner(model);
        this.spinner_nb_lectures.setMaximumSize(this.spinner_nb_lectures.getPreferredSize());
        box_nb_lectures.add(this.spinner_nb_lectures);
        this.add(box_nb_lectures);
        Box box_instruments = new Box(0);
        box_instruments.add(new JLabel("Instrument : "));
        this.combobox_instruments = new JComboBox<Instrument>(LecteurPartition.getInstruments());
        this.combobox_instruments.setMaximumSize(this.combobox_instruments.getPreferredSize());
        box_instruments.add(this.combobox_instruments);
        this.add(box_instruments);
        JButton button_demarrer_test = new JButton("D\u00e9marrer le test");
        button_demarrer_test.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DicteeNotesIHM.this.demarrerTest();
            }
        });
        this.add(button_demarrer_test);
        dictee_notes.ajouterControleur(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void signaler(EvenementMusique evenement) {
        switch (evenement.getType()) {
            case 4: {
                JOptionPane.showMessageDialog(null, ((EvenementMsg)evenement).getMsg());
                return;
            }
            case 0: {
                switch (this.etat) {
                    case 1: {
                        this.console.ajouterTexte("OK\n");
                        int tempo = this.slider_tempo.getValue();
                        Instrument instrument = (Instrument)this.combobox_instruments.getSelectedItem();
                        this.etat = 2;
                        ++this.nb_lectures;
                        this.console.ajouterTexte("Lecture de la dict\u00e9e (" + this.nb_lectures + "/" + this.spinner_nb_lectures.getValue() + ")\n");
                        this.dictee_notes.jouerDictee(instrument, tempo);
                        return;
                    }
                    case 2: {
                        this.etat = 0;
                        this.console.setVisible(false);
                        if (!(this.spinner_nb_lectures.getModel() instanceof SpinnerNumberModel)) return;
                        SpinnerNumberModel model = (SpinnerNumberModel)this.spinner_nb_lectures.getModel();
                        int value = model.getNumber().intValue();
                        if (this.nb_lectures >= value) {
                            Object[] actions = new String[]{"Voir la solution", "R\u00e9\u00e9couter la dict\u00e9e"};
                            Object r = null;
                            do {
                                if ((r = JOptionPane.showInputDialog(this, "Le test est fini, d\u00e9sirez-vous voir la solution, ou r\u00e9\u00e9couter la dict\u00e9e une nouvelle fois ?", "Solfege", 3, null, actions, actions[0])) != null) {
                                    if (r.equals(actions[0])) {
                                        this.afficherSolution();
                                    } else if (r.equals(actions[1])) {
                                        this.console.setVisible(true);
                                        this.lireDictee();
                                    }
                                }
                                if (r == null) return;
                            } while (r.equals(actions[0]));
                            return;
                        } else {
                            JOptionPane.showMessageDialog(this, "La dict\u00e9e a \u00e9t\u00e9 enti\u00e8rement lue, appuyez sur Entr\u00e9e lorsque vous serez pr\u00eat \u00e0 la r\u00e9\u00e9couter...", "Solfege", 1);
                            this.lireDictee();
                        }
                    }
                    default: {
                        return;
                    }
                }
            }
            case 1: {
                JOptionPane.showMessageDialog(this, "Les fonctions MIDI sont indisponibles sur cette machine !", "Solfege - Erreur", 0);
                return;
            }
        }
    }

    public void demarrerTest() {
        int longueur = this.slider_longueur.getValue();
        int nb_voies = this.slider_nbvoies.getValue();
        boolean sauts_octave = this.checkbox_sauts_octave.isSelected();
        this.console.setVisible(true);
        this.console.ajouterTexte("\nG\u00e9n\u00e9ration de la dict\u00e9e...");
        this.dictee_notes.genererDictee(longueur, nb_voies, sauts_octave);
        this.console.ajouterTexte("OK\n");
        this.nb_lectures = 0;
        this.lireDictee();
    }

    protected void interrompreDictee() {
        if (this.etat == 0) {
            return;
        }
        this.etat = 0;
        this.dictee_notes.arreterLecture();
        int r = JOptionPane.showConfirmDialog(this, "La lecture de la dict\u00e9e a \u00e9t\u00e9 interrompue. Voulez-vous voir la solution ?", "Solfege", 0, 3);
        if (r == 0) {
            this.afficherSolution();
        }
    }

    protected void lireDictee() {
        int tempo = this.slider_tempo.getValue();
        Instrument instrument = (Instrument)this.combobox_instruments.getSelectedItem();
        this.console.setVisible(true);
        this.console.ajouterTexte("\u00c9coute du la...");
        this.etat = 1;
        LecteurPartition lecteur = new LecteurPartition();
        lecteur.ajouterControleur(this);
        lecteur.charger(Partition.creerPartitionLa());
        lecteur.lire(instrument, tempo);
    }

    protected void afficherSolution() {
        DessinPartitionDialog dessin = new DessinPartitionDialog((Frame)this.ihm, "Solfege - Solution", true, this.dictee_notes.getPartition());
        dessin.setVisible(true);
    }

    public void loadPreferences(Preferences preferences) {
        this.slider_longueur.setValue(preferences.getInt("longueur", 10));
        this.checkbox_sauts_octave.setSelected(preferences.getBoolean("sauts_octave", false));
        this.slider_tempo.setValue(preferences.getInt("tempo", 60));
        this.spinner_nb_lectures.setValue(preferences.getInt("nb_lectures", 3));
        this.combobox_instruments.setSelectedIndex(preferences.getInt("instrument_index", 0));
    }

    public void savePreferences(Preferences preferences) {
        preferences.putInt("longueur", this.slider_longueur.getValue());
        preferences.putBoolean("sauts_octave", this.checkbox_sauts_octave.isSelected());
        preferences.putInt("tempo", this.slider_tempo.getValue());
        if (this.spinner_nb_lectures.getModel() instanceof SpinnerNumberModel) {
            SpinnerNumberModel model = (SpinnerNumberModel)this.spinner_nb_lectures.getModel();
            preferences.putInt("nb_lectures", model.getNumber().intValue());
        }
        preferences.putInt("instrument_index", this.combobox_instruments.getSelectedIndex());
    }
}

