/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import javax.sound.midi.Instrument;

public class DicteeNotes
implements MusiqueControleur {
    private Partition partition = null;
    private ArrayList<MusiqueControleur> controleurs = new ArrayList();
    private LecteurPartition lecteur = new LecteurPartition();

    public DicteeNotes() {
        this.lecteur.ajouterControleur(this);
    }

    public void genererDictee(int longueur, int nb_voies, boolean sauts_octave) {
        this.partition = new Partition();
        int j = 0;
        while (j < nb_voies) {
            Voie voie = this.partition.creerVoie();
            int previous = 24;
            int i = 0;
            while (i < longueur) {
                int type = Element.noteAleatoire(previous, sauts_octave);
                int duree = 4;
                voie.ajouter(type, duree);
                previous = type;
                ++i;
            }
            ++j;
        }
    }

    public void jouerDictee(Instrument instrument, int tempo) {
        this.lecteur.charger(this.partition);
        this.lecteur.lire(instrument, tempo);
    }

    public void arreterLecture() {
        this.lecteur.arreter();
    }

    public void ajouterControleur(MusiqueControleur controleur) {
        this.controleurs.add(controleur);
    }

    public void signaler(EvenementMusique evenement) {
        for (MusiqueControleur controleur : this.controleurs) {
            controleur.signaler(evenement);
        }
    }

    public Partition getPartition() {
        return this.partition;
    }
}

