/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.sound.midi.Instrument;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DicteeAgregatsIHM
extends JPanel
implements AgregatControleur {
    private SpinSlider spn_nb_notes;
    private SpinSlider spn_duree;
    private JComboBox cbx_instruments;
    private JButton btn_demarrer;
    private Console console;
    private DicteeAgregats dictee_agregats;
    private SolfegeIHM ihm;

    public DicteeAgregatsIHM(SolfegeIHM ihm, DicteeAgregats dictee_agregats) {
        this.ihm = ihm;
        this.dictee_agregats = dictee_agregats;
        dictee_agregats.ajouterControleur(this);
        this.console = new Console(ihm);
        this.console.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DicteeAgregatsIHM.this.interrompreTest();
            }
        });
        this.spn_nb_notes = new SpinSlider(1, 10, 1, 1);
        this.spn_duree = new SpinSlider(1, 10, 1, 1);
        this.cbx_instruments = new JComboBox<Instrument>(LecteurPartition.getInstruments());
        this.btn_demarrer = new JButton("D\u00e9marrer le test");
        this.btn_demarrer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DicteeAgregatsIHM.this.demarrerTest();
            }
        });
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        Box box_nb_notes = new Box(0);
        box_nb_notes.add(new JLabel("Nombre de notes : "));
        box_nb_notes.add(this.spn_nb_notes);
        this.add(box_nb_notes);
        Box box_duree = new Box(0);
        box_duree.add(new JLabel("Dur\u00e9e (s) : "));
        box_duree.add(this.spn_duree);
        this.add(box_duree);
        Box box_instruments = new Box(0);
        box_instruments.add(new JLabel("Instrument : "));
        this.cbx_instruments.setMaximumSize(this.cbx_instruments.getPreferredSize());
        box_instruments.add(this.cbx_instruments);
        this.add(box_instruments);
        Box box_btn = new Box(0);
        box_btn.add(this.btn_demarrer);
        this.add(box_btn);
    }

    public void interrompreTest() {
        this.dictee_agregats.arreterLecture();
        int r = JOptionPane.showConfirmDialog(this, "Le test a \u00e9t\u00e9 interrompu. Voulez-vous voir la solution ?", "Solfege", 0, 3);
        if (r == 0) {
            this.afficherSolution();
        }
    }

    public void demarrerTest() {
        int nb_notes = this.spn_nb_notes.getValue();
        int duree = this.spn_duree.getValue();
        this.console.setVisible(true);
        this.console.ajouterTexte("\nG\u00e9n\u00e9ration de l'agr\u00e9gat...");
        this.dictee_agregats.genererAgregat(nb_notes, duree);
        this.console.ajouterTexte("OK\n");
        this.lireAgregat();
    }

    public void lireAgregat() {
        Instrument instrument = (Instrument)this.cbx_instruments.getSelectedItem();
        this.dictee_agregats.jouerAgregat(instrument);
    }

    public void signaler(EvenementAgregat e) {
        switch (e.getType()) {
            case 2: {
                this.console.ajouterTexte("Lecture du la\n");
                break;
            }
            case 0: {
                this.console.ajouterTexte("Lecture de l'agr\u00e9gat\n");
                break;
            }
            case 1: {
                Object r;
                this.console.setVisible(false);
                Object[] actions = new String[]{"Voir la solution", "Refaire le test"};
                do {
                    if ((r = JOptionPane.showInputDialog(this, "Le test est fini, d\u00e9sirez-vous voir la solution, ou refaire le test une nouvelle fois ?", "Solfege", 3, null, actions, actions[1])) == null) continue;
                    if (r.equals(actions[0])) {
                        this.afficherSolution();
                        continue;
                    }
                    if (!r.equals(actions[1])) continue;
                    this.console.setVisible(true);
                    this.lireAgregat();
                } while (r != null && r.equals(actions[0]));
                break;
            }
            case -1: {
                JOptionPane.showMessageDialog(this, "Les fonctions MIDI sont indisponibles sur cette machine !", "Solfege - Erreur", 0);
                break;
            }
            case -2: {
                System.out.println("Bug de merde :(");
            }
        }
    }

    public void afficherSolution() {
        DessinPartitionDialog dessin = new DessinPartitionDialog((Frame)this.ihm, "Solfege - Solution", true, this.dictee_agregats.getAgregat().getPartition());
        dessin.setVisible(true);
    }

    public void loadPreferences(Preferences preferences) {
        this.spn_nb_notes.setValue(preferences.getInt("nb_notes", 5));
        this.spn_duree.setValue(preferences.getInt("duree", 3));
        this.cbx_instruments.setSelectedIndex(preferences.getInt("instrument_index", 0));
    }

    public void savePreferences(Preferences preferences) {
        preferences.putInt("nb_notes", this.spn_nb_notes.getValue());
        preferences.putInt("duree", this.spn_duree.getValue());
        preferences.putInt("instrument_index", this.cbx_instruments.getSelectedIndex());
    }
}

