/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import javax.sound.midi.Instrument;

public class DicteeAgregats
implements AgregatControleur {
    private ArrayList<AgregatControleur> controleurs = new ArrayList();
    private LecteurAgregat lecteur = new LecteurAgregat();
    Agregat agregat;

    public DicteeAgregats() {
        this.lecteur.ajouterControleur(this);
        this.agregat = null;
    }

    public void genererAgregat(int nb_notes, int duree) {
        Element[] notes = new Element[nb_notes];
        int i = 0;
        while (i < nb_notes) {
            notes[i] = new Element(0, 4, Element.noteAleatoire());
            ++i;
        }
        this.agregat = new Agregat(notes, duree);
    }

    public void jouerAgregat(Instrument instrument) {
        if (this.agregat == null) {
            return;
        }
        this.lecteur.charger(this.agregat);
        this.lecteur.lire(instrument);
    }

    public void arreterLecture() {
        this.lecteur.arreter();
    }

    public Agregat getAgregat() {
        return this.agregat;
    }

    public void signaler(EvenementAgregat e) {
        for (AgregatControleur c : this.controleurs) {
            c.signaler(e);
        }
    }

    public void ajouterControleur(AgregatControleur controleur) {
        this.controleurs.add(controleur);
    }
}

