/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class DessineurPartition
extends JComponent {
    private static final int LARGEUR_NOTE = 32;
    private static final int LARGEUR_CLE = 60;
    private static final int HAUTEUR_INTERLIGNE = 10;
    private static final int HAUTEUR_MARGE = 40;
    private static final int HAUTEUR = 200;
    private static final int HAUTEUR_QUEUE = 30;
    private static final int[] y_pos = new int[]{180, 180, 175, 175, 170, 165, 165, 160, 160, 155, 155, 150, 145, 145, 140, 140, 135, 130, 130, 125, 125, 120, 120, 115, 90, 90, 85, 85, 80, 75, 75, 70, 70, 65, 65, 60, 55, 55, 50, 50, 45, 40, 40, 35, 35, 30, 30, 25};
    private static int[] dieses = new int[]{1, 13, 25, 37, 3, 15, 27, 39, 6, 18, 30, 42, 8, 20, 32, 44, 10, 22, 34, 46};
    private Image image;
    static /* synthetic */ Class class$0;

    DessineurPartition(Partition partition) {
        this.image = this.genererImage(partition);
        this.setPreferredSize(new Dimension(this.image.getWidth(this), this.image.getHeight(this)));
    }

    protected void paintComponent(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
    }

    private Image genererImage(Partition partition) {
        int largeur = partition.getNbNotes() * 32 + 60;
        int hauteur = 200;
        BufferedImage image = new BufferedImage(largeur, hauteur, 1);
        Graphics2D g = image.createGraphics();
        this.dessinerPortee(g, partition);
        Voie[] voies = partition.getVoies();
        int i = 0;
        while (i < voies.length) {
            int x = 60;
            Voie.Iterateur voie = voies[i].iterateur();
            while (voie.elementDisponible()) {
                DessineurPartition.afficherElement(g, x, voie.elementCourant());
                voie.elementSuivant();
                x += 32;
            }
            ++i;
        }
        return image;
    }

    private void dessinerPortee(Graphics2D g, Partition partition) {
        int largeur = partition.getLongueur() * 32 + 60;
        g.setColor(Color.white);
        g.fillRect(0, 0, largeur, 200);
        Image cle_sol = new ImageIcon(SolfegeIHM.class.getResource("cle_sol.png")).getImage();
        Image cle_fa = new ImageIcon(SolfegeIHM.class.getResource("cle_fa.png")).getImage();
        g.drawImage(cle_sol, 2, 33, 25, 60, this);
        g.drawImage(cle_fa, 2, 122, 25, 25, this);
        g.setColor(Color.black);
        int i = 0;
        while (i < 5) {
            int y_sol = 40 + i * 10;
            g.drawLine(0, y_sol, largeur, y_sol);
            int y_fa = 120 + i * 10;
            g.drawLine(0, y_fa, largeur, y_fa);
            ++i;
        }
    }

    private static void afficherElement(Graphics2D g, int x, Element e) {
        g.setColor(Color.black);
        if (e.getType() == -1) {
            return;
        }
        int y = y_pos[e.getType()];
        if (y < 35) {
            g.drawLine(x - 8, 30, x + 8, 30);
        } else if (y > 165) {
            g.drawLine(x - 8, 170, x + 8, 170);
            if (y > 175) {
                g.drawLine(x - 8, 180, x + 8, 180);
            }
        } else if (e.getType() == 24 || e.getType() == 25) {
            g.drawLine(x - 8, 90, x + 8, 90);
        }
        switch (e.getDuree()) {
            case 4: {
                g.fillOval(x - 5, y - 5 + 1, 10, 8);
                g.drawLine(x + 5, y, x + 5, y - 30);
            }
        }
        boolean is_diese = false;
        int[] nArray = dieses;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int diese = nArray[n];
            if (e.getType() == diese) {
                is_diese = true;
            }
            ++n;
        }
        if (is_diese) {
            g.drawChars("#".toCharArray(), 0, 1, x - 10 - 5, y + 5);
        }
    }
}

