import java.util.ArrayList;

public class Voie {

	/**
	 * @uml.property  name="elements"
	 */
	private ArrayList<Element> elements;

	/**
	 * @uml.property  name="longueur" readOnly="true"
	 */
	private int longueur;

	/**
	 */
	public Voie(){
		longueur = 0;
		elements = new ArrayList<Element>();
	}

	/**
	 */
	public void ajouter(int type,int duree){
		elements.add(new Element(longueur,duree,type));
		longueur += duree;
	}

	/**
	 * Getter of the property <tt>longueur</tt>
	 * @return  Returns the longueur.
	 * @uml.property  name="longueur"
	 */
	public int getLongueur() {
		return longueur;
	}
	
	public int getNbNotes()
	{
		return elements.size();
	}
	
	public Iterateur iterateur()
	{
		return new Iterateur();
	}
	
	public class Iterateur
	{
		private int index;

		public Iterateur()
		{
			index = 0;
		}
		
		public Element elementCourant()
		{
			return elements.get(index);
		}
		
		public void elementSuivant()
		{
			index++;
		}
		
		public boolean elementDisponible()
		{
			return index < elements.size();
		}
	}
}
