import java.util.ArrayList;

import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Synthesizer;


public class LecteurAgregat implements Runnable {

	private Instrument instrument;

	private int thread_etat;
	private Thread thread;
	private static final int ETAT_MORT = 0;
	private static final int ETAT_EXECUTE = 1;
	private static final int ETAT_SUSPENDU = 2;
	
	private ArrayList<AgregatControleur> controleurs;
	private Agregat agregat;
	
	public LecteurAgregat()
	{
		controleurs = new ArrayList<AgregatControleur>();
		agregat = null;
		thread = null;
		setEtatThread(ETAT_MORT);
	}
	
	public void ajouterControleur(AgregatControleur c)
	{
		controleurs.add(c);
	}
	
	public void charger(Agregat a)
	{
		agregat = a;
	}

	public void lire(Instrument instrument)
	{
		if(agregat == null)
		{
			signaler(new EvenementAgregat(EvenementAgregat.PAS_D_AGREGAT));
			return;
		}
		
		this.instrument = instrument;
		
		thread = new Thread(this);
		thread.start();
	}
	
	public void suspendre()
	{
		int etat = getEtatThread();
		if(etat == ETAT_EXECUTE)
			setEtatThread(ETAT_SUSPENDU);
		else if(etat == ETAT_SUSPENDU)
			setEtatThread(ETAT_EXECUTE);
	}
	
	public void arreter()
	{
		setEtatThread(ETAT_MORT);
		if(thread != null)
			thread.interrupt();
	}
	
	public void run()
	{
		MidiChannel channel;
		Synthesizer synth;

		setEtatThread(ETAT_EXECUTE);

		try
		{
			synth = MidiSystem.getSynthesizer();
			synth.open();
			channel = synth.getChannels()[0];
			channel.allSoundOff();
			channel.programChange(instrument.getPatch().getBank(),instrument.getPatch().getProgram());
		}
		catch(Exception exc)
		{
			signaler(new EvenementAgregat(EvenementAgregat.MIDI_NON_SUPPORTE));
			return;
		}

		// Lecture du la
		signaler(new EvenementAgregat(EvenementAgregat.LA_LU));
		channel.noteOn(Element.LA3 + Element.OFFSET_TO_MIDI,63);
		attendre(1000);
		if(getEtatThread() == ETAT_MORT) {synth.close(); return;}
		channel.noteOff(Element.LA3 + Element.OFFSET_TO_MIDI,63);

		attendre(750);
		if(getEtatThread() == ETAT_MORT) {synth.close(); return;}
		
		// Lecture de l'agegat
		Element[] notes = agregat.getNotes();

		signaler(new EvenementAgregat(EvenementAgregat.AGREGAT_LU));
		for(Element note : notes)
			channel.noteOn(note.getType() + Element.OFFSET_TO_MIDI,63);
		
		attendre(agregat.getDuree() * 1000);		
		if(getEtatThread() == ETAT_MORT) {synth.close(); return;}

		for(Element note : notes)
			channel.noteOff(note.getType() + Element.OFFSET_TO_MIDI,63);
		
		synth.close();
		signaler(new EvenementAgregat(EvenementAgregat.AGREGAT_FINI));
	}
	
	protected void attendre(int ms)
	{
		try
		{
			Thread.sleep(ms);
		}
		catch(InterruptedException e){}
	}

	protected void signaler(EvenementAgregat e){
		for(AgregatControleur controleur: controleurs)
			controleur.signaler(e);
	}

	private synchronized void setEtatThread(int etat)
	{
		thread_etat = etat;
	}
	
	private synchronized int getEtatThread()
	{
		return thread_etat;
	}
}
