import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.*;
import java.awt.event.*;
import javax.sound.midi.Instrument;
import java.util.prefs.*;


public class DicteeNotesIHM extends JPanel implements MusiqueControleur {

	private SolfegeIHM ihm;
	
	/** 
	 * @uml.property name="console"
	 * @uml.associationEnd inverse="dicteeNotesIHM:Console"
	 */
	private Console console;

	/** 
	 * @uml.property name="dictee_notes"
	 * @uml.associationEnd inverse="dicteeNotesIHM:DicteeNotes"
	 */
	private DicteeNotes dictee_notes;
	
	private SpinSlider slider_longueur;
	private JCheckBox checkbox_sauts_octave;
	private SpinSlider slider_tempo;
	private JSpinner spinner_nb_lectures;
	private JComboBox combobox_instruments;

	private int etat;
	private static final int ATTENTE = 0;
	private static final int LECTURE_LA = 1;
	private static final int LECTURE_DICTEE = 2;
	private int nb_lectures;
	
	/**
	 */
	public DicteeNotesIHM(SolfegeIHM ihm,DicteeNotes dictee_notes){
		this.ihm = ihm;
		this.dictee_notes = dictee_notes;
		console = new Console(ihm);
		console.addWindowListener(new WindowAdapter(){
			public void windowClosing(WindowEvent e)
			{
				interrompreDictee();
			}
		});
		
		etat = ATTENTE;
		nb_lectures = 0;
		
		BoxLayout layout = new BoxLayout(this,BoxLayout.Y_AXIS);
		this.setLayout(layout);
		
		Box box_longueur = new Box(BoxLayout.X_AXIS);
		box_longueur.add(new JLabel("Nombre de notes : "));
		slider_longueur = new SpinSlider(0,30,1,5);
		box_longueur.add(slider_longueur);
		add(box_longueur);
		
		Box box_sauts_octave = new Box(BoxLayout.X_AXIS);
		checkbox_sauts_octave = new JCheckBox("Autoriser les sauts d'octave");
		box_sauts_octave.add(checkbox_sauts_octave);
		add(box_sauts_octave);
		
		Box box_tempo = new Box(BoxLayout.X_AXIS);
		box_tempo.add(new JLabel("Tempo (bpm) : "));
		slider_tempo = new SpinSlider(30,120,1,10);
		box_tempo.add(slider_tempo);
		add(box_tempo);
		
		Box box_nb_lectures = new Box(BoxLayout.X_AXIS);
		box_nb_lectures.add(new JLabel("Nombre de lectures : "));
		SpinnerNumberModel model = new SpinnerNumberModel(2,1,10,1);
		spinner_nb_lectures = new JSpinner(model);
		spinner_nb_lectures.setMaximumSize(spinner_nb_lectures.getPreferredSize());
		box_nb_lectures.add(spinner_nb_lectures);
		add(box_nb_lectures);
		
		Box box_instruments = new Box(BoxLayout.X_AXIS);
		box_instruments.add(new JLabel("Instrument : "));
		combobox_instruments = new JComboBox(LecteurPartition.getInstruments());
		combobox_instruments.setMaximumSize(combobox_instruments.getPreferredSize());
		box_instruments.add(combobox_instruments);
		add(box_instruments);
		
		JButton button_demarrer_test = new JButton("Dmarrer le test");
		button_demarrer_test.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e)
			{
				demarrerTest();
			}
		});
		add(button_demarrer_test);

		dictee_notes.ajouterControleur(this);
	}

	public void signaler(EvenementMusique evenement) {
		switch(evenement.getType())
		{
		case EvenementMusique.MESSAGE:
			JOptionPane.showMessageDialog(null,((EvenementMsg)evenement).getMsg());
//			console.ajouterTexte(((EvenementDebug)evenement).getMsg());
			break;
			
		case EvenementMusique.PARTITION_FINIE:
			switch(etat)
			{
			case LECTURE_LA:
				{
					console.ajouterTexte("OK\n");

					int tempo = slider_tempo.getValue();
					Instrument instrument = (Instrument)combobox_instruments.getSelectedItem();

					etat = LECTURE_DICTEE;
					nb_lectures++;
					console.ajouterTexte("Lecture de la dicte (" + nb_lectures + "/" + spinner_nb_lectures.getValue() + ")\n");
					dictee_notes.jouerDictee(instrument,tempo);
				}
				break;
			case LECTURE_DICTEE:
				etat = ATTENTE;
				console.setVisible(false);
				if(spinner_nb_lectures.getModel() instanceof SpinnerNumberModel)
				{
					SpinnerNumberModel model = (SpinnerNumberModel)spinner_nb_lectures.getModel(); 
					int value = model.getNumber().intValue();
					if(nb_lectures >= value) // Les lectures ont toutes t faites
					{
						String[] actions = {"Voir la solution","Rcouter la dicte"};
						Object r = null;
						do
						{
							r = JOptionPane.showInputDialog(this,"Le test est fini, dsirez-vous voir la solution, ou rcouter la dicte une nouvelle fois ?","Solfege",JOptionPane.QUESTION_MESSAGE,null,actions,actions[0]);
							if(r != null)
							{
								if(r.equals(actions[0]))
								{
									afficherSolution();
								}
								else if(r.equals(actions[1]))
								{
									console.setVisible(true);
									lireDictee();
								}
							}
						}while(r != null && r.equals(actions[0]));
					}
					else
					{
						JOptionPane.showMessageDialog(this,"La dicte a t entirement lue, appuyez sur Entre lorsque vous serez prt  la rcouter...","Solfege",JOptionPane.INFORMATION_MESSAGE);
						lireDictee();
					}
				}
				break;
			}
			break;
			
		case EvenementMusique.MIDI_INDISPONIBLE:
			JOptionPane.showMessageDialog(this,"Les fonctions MIDI sont indisponibles sur cette machine !","Solfege - Erreur",JOptionPane.ERROR_MESSAGE);
			break;
			
		default:
//			console.ajouterTexte("vnement : " + evenement.getType() + "\n");
			break;
		}
	}

			
	/**
	 */
	public void demarrerTest(){
		int longueur = slider_longueur.getValue();
		boolean sauts_octave = checkbox_sauts_octave.isSelected();
		
		console.setVisible(true);
		console.ajouterTexte("\nGnration de la dicte...");
		dictee_notes.genererDictee(longueur,sauts_octave);
		console.ajouterTexte("OK\n");
		
		nb_lectures = 0;
		lireDictee();
	}
	
	protected void interrompreDictee()
	{
		if(etat == ATTENTE)
			return;
		
		etat = ATTENTE;
		dictee_notes.arreterLecture();
		
		int r = JOptionPane.showConfirmDialog(this,"La lecture de la dicte a t interrompue. Voulez-vous voir la solution ?","Solfege",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE);
		if(r == JOptionPane.YES_OPTION)
		{
			afficherSolution();
		}
	}
	
	protected void lireDictee()
	{
		int tempo = slider_tempo.getValue();
		Instrument instrument = (Instrument)combobox_instruments.getSelectedItem();

		console.setVisible(true);
		console.ajouterTexte("coute du la...");
		etat = LECTURE_LA;
		LecteurPartition lecteur = new LecteurPartition();
		lecteur.ajouterControleur(this);
		lecteur.charger(Partition.creerPartitionLa());
		lecteur.lire(instrument,tempo);
	}
	
	protected void afficherSolution()
	{
		DessinPartitionDialog dessin = new DessinPartitionDialog(ihm,"Solfege - Solution",true,dictee_notes.getPartition()); 
		dessin.setVisible(true);
	}
	
	public void loadPreferences(Preferences preferences)
	{
		slider_longueur.setValue(preferences.getInt("longueur",10));
		checkbox_sauts_octave.setSelected(preferences.getBoolean("sauts_octave",false));
		slider_tempo.setValue(preferences.getInt("tempo",60));
		spinner_nb_lectures.setValue(preferences.getInt("nb_lectures",3));
		combobox_instruments.setSelectedIndex(preferences.getInt("instrument_index",0));
	}
	
	public void savePreferences(Preferences preferences)
	{
		preferences.putInt("longueur",slider_longueur.getValue());
		preferences.putBoolean("sauts_octave",checkbox_sauts_octave.isSelected());
		preferences.putInt("tempo",slider_tempo.getValue());
		if(spinner_nb_lectures.getModel() instanceof SpinnerNumberModel)
		{
			SpinnerNumberModel model = (SpinnerNumberModel)spinner_nb_lectures.getModel(); 
			preferences.putInt("nb_lectures",model.getNumber().intValue());
		}
		preferences.putInt("instrument_index",combobox_instruments.getSelectedIndex());
	}
}
