import java.awt.event.*;
import javax.swing.*;
import javax.sound.midi.Instrument;
import java.util.prefs.*;

public class DicteeAgregatsIHM extends JPanel implements AgregatControleur {

	private SpinSlider spn_nb_notes;
	private SpinSlider spn_duree;
	private JComboBox cbx_instruments;
	private JButton btn_demarrer;
	private Console console;
	
	private DicteeAgregats dictee_agregats;
	
	private SolfegeIHM ihm;
	
	public DicteeAgregatsIHM(SolfegeIHM ihm,DicteeAgregats dictee_agregats)
	{
		this.ihm = ihm;
		
		this.dictee_agregats = dictee_agregats;
		dictee_agregats.ajouterControleur(this);
		
		console = new Console(ihm);
		console.addWindowListener(new WindowAdapter(){
			public void windowClosing(WindowEvent e)
			{
				interrompreTest();
			}
		});

		spn_nb_notes = new SpinSlider(1,10,1,1);
		spn_duree = new SpinSlider(1,10,1,1);
		cbx_instruments = new JComboBox(LecteurPartition.getInstruments());
		btn_demarrer = new JButton("Dmarrer le test");
		btn_demarrer.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				demarrerTest();
			}
		});
		
		BoxLayout layout = new BoxLayout(this,BoxLayout.Y_AXIS);
		this.setLayout(layout);
		
		Box box_nb_notes = new Box(BoxLayout.X_AXIS);
		box_nb_notes.add(new JLabel("Nombre de notes : "));
		box_nb_notes.add(spn_nb_notes);
		add(box_nb_notes);
		
		Box box_duree = new Box(BoxLayout.X_AXIS);
		box_duree.add(new JLabel("Dure (s) : "));
		box_duree.add(spn_duree);
		add(box_duree);
		
		Box box_instruments = new Box(BoxLayout.X_AXIS);
		box_instruments.add(new JLabel("Instrument : "));
		cbx_instruments.setMaximumSize(cbx_instruments.getPreferredSize());
		box_instruments.add(cbx_instruments);
		add(box_instruments);
		
		Box box_btn = new Box(BoxLayout.X_AXIS);
		box_btn.add(btn_demarrer);
		add(box_btn);
	}
	
	public void interrompreTest()
	{
		dictee_agregats.arreterLecture();

		int r = JOptionPane.showConfirmDialog(this,"Le test a t interrompu. Voulez-vous voir la solution ?","Solfege",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE);
		if(r == JOptionPane.YES_OPTION)
		{
			afficherSolution();
		}
	}
	
	public void demarrerTest()
	{
		int nb_notes = spn_nb_notes.getValue();
		int duree = spn_duree.getValue();
		
		console.setVisible(true);
		console.ajouterTexte("\nGnration de l'agrgat...");
		dictee_agregats.genererAgregat(nb_notes,duree);
		console.ajouterTexte("OK\n");
		lireAgregat();
	}
	
	public void lireAgregat()
	{
		Instrument instrument = (Instrument)cbx_instruments.getSelectedItem();

		dictee_agregats.jouerAgregat(instrument);
	}
	
	public void signaler(EvenementAgregat e)
	{
		switch(e.getType())
		{
		case EvenementAgregat.LA_LU:
			console.ajouterTexte("Lecture du la\n");
			break;
			
		case EvenementAgregat.AGREGAT_LU:
			console.ajouterTexte("Lecture de l'agrgat\n");
			break;
			
		case EvenementAgregat.AGREGAT_FINI:
			console.setVisible(false);
			String[] actions = {"Voir la solution","Refaire le test"}; 
			Object r;
			do
			{
				r = JOptionPane.showInputDialog(this,"Le test est fini, dsirez-vous voir la solution, ou refaire le test une nouvelle fois ?","Solfege",JOptionPane.QUESTION_MESSAGE,null,actions,actions[1]);
				if(r != null)
				{
					if(r.equals(actions[0]))
					{
						afficherSolution();
					}
					else if(r.equals(actions[1]))
					{
						console.setVisible(true);
						lireAgregat();
					}
				}
			}while(r != null && r.equals(actions[0]));
			break;
			
		case EvenementAgregat.MIDI_NON_SUPPORTE:
			JOptionPane.showMessageDialog(this,"Les fonctions MIDI sont indisponibles sur cette machine !","Solfege - Erreur",JOptionPane.ERROR_MESSAGE);
			break;
			
		case EvenementAgregat.PAS_D_AGREGAT:
			System.out.println("Bug de merde :(");
			break;
		}
	}
	
	public void afficherSolution()
	{
		DessinPartitionDialog dessin = new DessinPartitionDialog(ihm,"Solfege - Solution",true,dictee_agregats.getAgregat().getPartition()); 
		dessin.setVisible(true);
	}
	
	public void loadPreferences(Preferences preferences)
	{
		spn_nb_notes.setValue(preferences.getInt("nb_notes",5));
		spn_duree.setValue(preferences.getInt("duree",3));
		cbx_instruments.setSelectedIndex(preferences.getInt("instrument_index",0));
	}
	
	public void savePreferences(Preferences preferences)
	{
		preferences.putInt("nb_notes",spn_nb_notes.getValue());
		preferences.putInt("duree",spn_duree.getValue());
		preferences.putInt("instrument_index",cbx_instruments.getSelectedIndex());
	}
}
