import javax.swing.*;
import javax.swing.event.*;

public class SpinSlider extends JPanel {

	private JSlider slider;
	private JSpinner spinner;
	private int max,min;
	
	public SpinSlider(int min,int max,int step,int tick_spacing) {
		super();
		
		this.max = max;
		this.min = min;
		
		slider = new JSlider(min,max);
		slider.setMajorTickSpacing(tick_spacing);
		slider.setPaintTicks(true);
		slider.setPaintLabels(true);

		SpinnerNumberModel model = new SpinnerNumberModel((min + max)/2,min,max,step);
		spinner = new JSpinner(model);
		
		slider.addChangeListener(new ChangeListener()
				{
					public void stateChanged(ChangeEvent e)
					{
						sliderChanged();
					}
				});
		spinner.addChangeListener(new ChangeListener()
				{
					public void stateChanged(ChangeEvent e)
					{
						spinnerChanged();
					}
				});
		
		BoxLayout layout = new BoxLayout(this,BoxLayout.X_AXIS);
		setLayout(layout);
		
		spinner.setMaximumSize(spinner.getPreferredSize());
		
		add(spinner);
		add(slider);
	}

	public int getValue()
	{
		return slider.getValue();
	}
	
	public void setValue(int value)
	{
		if(value > max)
			value = max;
		else if(value < min)
			value = min;
		slider.setValue(value);
	}
	
	protected void sliderChanged()
	{
		int value = slider.getValue();
		if(spinner.getValue() != new Integer(value))
		{
			spinner.setValue(value);
		}
	}

	protected void spinnerChanged()
	{
		if(spinner.getModel() instanceof SpinnerNumberModel)
		{
			SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
			int value = model.getNumber().intValue();
			if(slider.getValue() != value)
			{
				slider.setValue(value);
			}
		}
	}
	
	public void setEnabled(boolean enabled)
	{
		slider.setEnabled(enabled);
		spinner.setEnabled(enabled);
	}
}
