import javax.swing.*;
import java.awt.*;
import java.util.prefs.*;
import java.awt.event.*;


public class SolfegeIHM extends JFrame {

	/**
	 * @uml.property  name="solfege" readOnly="true"
	 * @uml.associationEnd  inverse="solfegeIHM:Solfege"
	 */
	private Solfege solfege;

	public static void main(String[] args)
	{
		SolfegeIHM ihm = new SolfegeIHM();
		ihm.setVisible(true);
	}

	/**
	 */
	public SolfegeIHM(){
		super("Solfge");

		solfege = new Solfege();
		
		final DicteeNotesIHM dictee_notes;
		final ReconnaissanceIntervallesIHM reconnaissance_intervalles;
		final DicteeAgregatsIHM dictee_agregats;
		final ReconnaissanceAccordsIHM reconnaissance_accords;
		
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		
		JTabbedPane tabbed_pane = new JTabbedPane();
		tabbed_pane.add("Dicte de notes",dictee_notes = new DicteeNotesIHM(this,solfege.getDicteeNotes()));
		tabbed_pane.add("Reconnaissance d'intervalles",reconnaissance_intervalles = new ReconnaissanceIntervallesIHM(this,solfege.getReconnaissanceIntervalles()));
		tabbed_pane.add("Dicte d'accords et d'agrgats",dictee_agregats = new DicteeAgregatsIHM(this,solfege.getDicteeAgregats()));
		tabbed_pane.add("Reconnaissance d'accords",reconnaissance_accords = new ReconnaissanceAccordsIHM(this,solfege.getReconnaissanceAccords()));
		
		add(tabbed_pane,BorderLayout.CENTER);
		
		final Preferences preferences = Preferences.userRoot().node("/apps/Solfege");
		try
		{
			dictee_notes.loadPreferences(preferences.node("DicteeNotes"));
			reconnaissance_intervalles.loadPreferences(preferences.node("ReconnaissanceIntervalles"));
			dictee_agregats.loadPreferences(preferences.node("DicteeAgregats"));
			reconnaissance_accords.loadPreferences(preferences.node("ReconnaissanceAccords"));
		}
		catch(Exception e) {}
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e)
			{
				try
				{
					dictee_notes.savePreferences(preferences.node("DicteeNotes"));
					reconnaissance_intervalles.savePreferences(preferences.node("ReconnaissanceIntervalles"));
					dictee_agregats.savePreferences(preferences.node("DicteeAgregats"));
					reconnaissance_accords.savePreferences(preferences.node("ReconnaissanceAccords"));
				}
				catch(Exception ex) {}
			}
		});
		
		pack();
	}

		
	/**
	 * Getter of the property <tt>solfege</tt>
	 * @return  Returns the solfege.
	 * @uml.property  name="solfege"
	 */
	public Solfege getSolfege() {
		return solfege;
	}
}
