import javax.swing.*;
import java.awt.event.*;
import javax.sound.midi.Instrument;
import java.util.prefs.*;

public class ReconnaissanceIntervallesIHM extends JPanel implements SerieIntervallesControleur {

	private ReconnaissanceIntervalles reconnaissance_intervalles;
	private SolfegeIHM ihm;
	
	private JComboBox cmb_style;
	private JComboBox cmb_arpege;
	private JComboBox cmb_notes_gardees;
	private SpinSlider spn_tps_gardees;
	private JCheckBox chk_sauts_octave;
	private SpinSlider spn_nb_intervalles;
	private SpinSlider spn_tps_intermediaire;
	private JComboBox cmb_instruments;
	private JButton btn_demarrer;
	
	private Console console;
	
	private int etat;

	private static final int ETAT_ATTENTE = 0;
	private static final int ETAT_LECTURE = 1;
	
	private static final String[] str_styles = {"Plaqu","Arpg","Alatoire"};
	private static final int STYLE_PLAQUE = 0;
	private static final int STYLE_ARPEGE = 1;
	private static final int STYLE_ALEATOIRE = 2;
	private static final int[] correspondance_style = {Intervalle.STYLE_PLAQUE,Intervalle.STYLE_ARPEGE,Intervalle.STYLE_ALEATOIRE};
	private static final String[] str_arpege = {"Montant","Descendant","Alatoire"};
	private static final int ARPEGE_MONTANT = 0;
	private static final int ARPEGE_DESCENDANT = 1;
	private static final int ARPEGE_ALEATOIRE = 2;
	private static final int[] correspondance_arpege = {Intervalle.STYLE_ARPEGE_MONTANT,Intervalle.STYLE_ARPEGE_DESCENDANT,Intervalle.STYLE_ARPEGE_ALEATOIRE};
	private static final String[] str_notes_gardees = {"Gardes","Piques"};
	private static final int NOTES_GARDEES = 0;
	private static final int NOTES_PIQUEES = 1;

	public ReconnaissanceIntervallesIHM(SolfegeIHM ihm,ReconnaissanceIntervalles reconnaissance_intervalles)
	{
		this.ihm = ihm;
		etat = ETAT_ATTENTE;
		
		this.reconnaissance_intervalles = reconnaissance_intervalles;
		reconnaissance_intervalles.ajouterControleur(this);
		
		console = new Console(ihm);
		console.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e)
			{
				consoleClosed();
			}
		});
		
		cmb_style = new JComboBox(str_styles);
		cmb_style.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				styleChanged();
			}
		});

		cmb_arpege = new JComboBox(str_arpege);

		cmb_notes_gardees = new JComboBox(str_notes_gardees);
		cmb_notes_gardees.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				notesGardeesChanged();
			}
		});

		spn_tps_gardees = new SpinSlider(100,1000,10,300);

		chk_sauts_octave = new JCheckBox("Autoriser les sauts d'octave");

		spn_nb_intervalles = new SpinSlider(1,10,1,3);

		spn_tps_intermediaire = new SpinSlider(1,5,1,1);

		cmb_instruments = new JComboBox(LecteurPartition.getInstruments());

		btn_demarrer = new JButton("Dmarrer le test");
		btn_demarrer.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				demarrerClicked();
			}
		});
		
		BoxLayout layout = new BoxLayout(this,BoxLayout.Y_AXIS);
		this.setLayout(layout);
		
		Box box_style = new Box(BoxLayout.X_AXIS);
		box_style.add(new JLabel("Style : "));
		cmb_style.setMaximumSize(cmb_style.getPreferredSize());
		box_style.add(cmb_style);
		box_style.add(new JLabel("Arpg : "));
		cmb_arpege.setMaximumSize(cmb_arpege.getPreferredSize());
		box_style.add(cmb_arpege);
		add(box_style);
		
		Box box_notes = new Box(BoxLayout.X_AXIS);
		box_notes.add(new JLabel("Notes : "));
		cmb_notes_gardees.setMaximumSize(cmb_notes_gardees.getPreferredSize());
		box_notes.add(cmb_notes_gardees);
		box_notes.add(new JLabel("Gardes (ms) : "));
		box_notes.add(spn_tps_gardees);
		add(box_notes);
		
		Box box_sauts = new Box(BoxLayout.X_AXIS);
		box_sauts.add(chk_sauts_octave);
		add(box_sauts);
		
		Box box_lecture = new Box(BoxLayout.X_AXIS);
		box_lecture.add(new JLabel("Nombre d'intervalles par srie : "));
		box_lecture.add(spn_nb_intervalles);
		add(box_lecture);

		Box box_lecture2 = new Box(BoxLayout.X_AXIS);
		box_lecture2.add(new JLabel("Temps entre chaque intervalle (s) : "));
		box_lecture2.add(spn_tps_intermediaire);
		add(box_lecture2);

		Box box_instruments = new Box(BoxLayout.X_AXIS);
		box_instruments.add(new JLabel("Instrument : "));
		cmb_instruments.setMaximumSize(cmb_instruments.getPreferredSize());
		box_instruments.add(cmb_instruments);
		add(box_instruments);
		
		Box box_btn = new Box(BoxLayout.X_AXIS);
		box_btn.add(btn_demarrer);
		add(box_btn);
	}
	
	protected void styleChanged()
	{
		cmb_arpege.setEnabled(cmb_style.getSelectedIndex() != STYLE_PLAQUE);
	}
	
	protected void notesGardeesChanged()
	{
		spn_tps_gardees.setEnabled(cmb_notes_gardees.getSelectedIndex() != NOTES_PIQUEES);
	}
	
	protected void consoleClosed()
	{
		if(etat == ETAT_ATTENTE)
			return;
		
		reconnaissance_intervalles.arreterLecture();
		int r = JOptionPane.showConfirmDialog(this,"Le test a t interrompu. Voulez-vous voir la solution ?","Solfege",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE);
		if(r == JOptionPane.YES_OPTION)
		{
			afficherSolution();
		}
	}
	
	protected void demarrerClicked()
	{
		int nb_intervalles = spn_nb_intervalles.getValue();
		int style = correspondance_style[cmb_style.getSelectedIndex()];
		int style_arpege = correspondance_arpege[cmb_arpege.getSelectedIndex()];
		boolean sauts_octave = chk_sauts_octave.isSelected();
		int tps_attente = spn_tps_intermediaire.getValue();
		int tps_notes_gardees = spn_tps_gardees.getValue();
		if(cmb_notes_gardees.getSelectedIndex() == NOTES_PIQUEES)
		{
			tps_notes_gardees = SerieIntervalles.NOTES_PIQUEES;
		}
		
		console.setVisible(true);
		console.ajouterTexte("\nGnration de la srie d'intervalles...");
		reconnaissance_intervalles.genererSerie(nb_intervalles,style,style_arpege,sauts_octave,tps_attente,tps_notes_gardees);
		console.ajouterTexte("OK\n");
		
		lireSerie();
	}
	
	protected void lireSerie()
	{
		etat = ETAT_LECTURE;
		Instrument instrument = (Instrument)cmb_instruments.getSelectedItem();
		
		reconnaissance_intervalles.jouerSerie(instrument);
	}
	
	public void signaler(EvenementSerieIntervalles e)
	{
		switch(e.getType())
		{
		case EvenementSerieIntervalles.INTERVALLE_LU:
			{
				EvenementIntervalleLu ev = (EvenementIntervalleLu)e;
				console.ajouterTexte("Lecture de l'intervalle " + ev.getNum() + "/" + ev.getNb() + "\n");
			}
			break;
			
		case EvenementSerieIntervalles.INTERVALLE_FINI:
			break;
			
		case EvenementSerieIntervalles.SERIE_LUE:
			console.ajouterTexte("Lecture de la srie\n");
			break;
			
		case EvenementSerieIntervalles.SERIE_FINIE:
			etat = ETAT_ATTENTE;
			console.setVisible(false);
			String[] actions = {"Voir la solution","Refaire le test"}; 
			Object r;
			do
			{
				r = JOptionPane.showInputDialog(this,"Le test est fini, dsirez-vous voir la solution, ou refaire le test une nouvelle fois ?","Solfege",JOptionPane.QUESTION_MESSAGE,null,actions,actions[0]);
				if(r != null)
				{
					if(r.equals(actions[0]))
					{
						afficherSolution();
					}
					else if(r.equals(actions[1]))
					{
						console.setVisible(true);
						lireSerie();
					}
				}
			}while(r != null && r.equals(actions[0]));
			break;
		
		case EvenementSerieIntervalles.MIDI_NON_SUPPORTE:
			JOptionPane.showMessageDialog(this,"Les fonctions MIDI sont indisponibles sur cette machine !","Solfege - Erreur",JOptionPane.ERROR_MESSAGE);
			break;
			
		default:
			console.ajouterTexte("vnement : " + e.getType() + "\n");
			break;
		}
	}
	
	public void afficherSolution()
	{
		DessinSerieIntervallesDialog dessin = new DessinSerieIntervallesDialog(ihm,"Solfge - Solution",true,reconnaissance_intervalles.getSerie()); 
		dessin.setVisible(true);
	}
	
	public void loadPreferences(Preferences preferences)
	{
		cmb_style.setSelectedIndex(preferences.getInt("style",0));
		cmb_arpege.setSelectedIndex(preferences.getInt("arpege",0));
		cmb_notes_gardees.setSelectedIndex(preferences.getInt("notes_gardees",0));
		spn_tps_gardees.setValue(preferences.getInt("tps_gardees",500));
		chk_sauts_octave.setSelected(preferences.getBoolean("sauts_octave",false));
		spn_nb_intervalles.setValue(preferences.getInt("nb_intervalles",5));
		spn_tps_intermediaire.setValue(preferences.getInt("tps_intermediaire",2));
		cmb_instruments.setSelectedIndex(preferences.getInt("instrument_index",0));
	}
	
	public void savePreferences(Preferences preferences)
	{
		preferences.putInt("style",cmb_style.getSelectedIndex());
		preferences.putInt("arpege",cmb_arpege.getSelectedIndex());
		preferences.putInt("notes_gardees",cmb_notes_gardees.getSelectedIndex());
		preferences.putInt("tps_gardees",spn_tps_gardees.getValue());
		preferences.putBoolean("sauts_octave",chk_sauts_octave.isSelected());
		preferences.putInt("nb_intervalles",spn_nb_intervalles.getValue());
		preferences.putInt("tps_intermediaire",spn_tps_intermediaire.getValue());
		preferences.putInt("instrument_index",cmb_instruments.getSelectedIndex());
	}
}
