import javax.sound.midi.*;
import java.util.*;


public class ReconnaissanceIntervalles implements SerieIntervallesControleur {

	private ArrayList<SerieIntervallesControleur> controleurs;
	private LecteurSerieIntervalles lecteur;
	private SerieIntervalles serie;
	
	public ReconnaissanceIntervalles()
	{
		controleurs = new ArrayList<SerieIntervallesControleur>();
		serie = null;
		lecteur = new LecteurSerieIntervalles();
		lecteur.ajouterControleur(this);
	}
	
	public void genererSerie(int nb,int style,int style_arpege,boolean sauts_octave,int tps_attente,int tps_notes_gardees)
	{
		Intervalle[] intervalles = new Intervalle[nb];
		for(int i = 0 ; i < nb ; i++)
		{
			intervalles[i] = Intervalle.intervalleAleatoire(style,style_arpege,sauts_octave);
		}
		
		serie = new SerieIntervalles(intervalles,tps_attente,tps_notes_gardees);
	}
	
	public SerieIntervalles getSerie()
	{
		return serie;
	}
	
	public void jouerSerie(Instrument instrument)
	{
		if(serie == null)
			return;

		lecteur.charger(serie);
		lecteur.lire(instrument);
	}
	
	public void arreterLecture()
	{
		lecteur.arreter();
	}
	
	public void ajouterControleur(SerieIntervallesControleur c)
	{
		controleurs.add(c);
	}
	
	public void signaler(EvenementSerieIntervalles e)
	{
		for(SerieIntervallesControleur controleur : controleurs)
			controleur.signaler(e);
	}
}
