import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.*;
import java.io.*;

import javax.sound.midi.Instrument;
import javax.swing.*;

public class ReconnaissanceAccordsIHM extends JPanel implements SerieAccordsControleur {

	private Console console;
	private SolfegeIHM ihm;
	private ReconnaissanceAccords reconnaissance_accords;
	
	private JCheckBox chk_tous_types;
	private JList lst_type;
	private JCheckBox chk_notes_doublees;
	private JComboBox cmb_style;
	private JComboBox cmb_arpege;
	private JComboBox cmb_notes_gardees;
	private SpinSlider spn_nb_notes;
	private SpinSlider spn_tps_gardees;
	private SpinSlider spn_nb_accords;
	private SpinSlider spn_tps_intermediaire;
	private JComboBox cmb_instruments;
	private JButton btn_demarrer;

	private static final String[] str_types = {"Parfait","Quinte diminue","Quinte augmente","Septime dominante","Septime diminue","Septime d'espce"};
	private static final int[] correspondance_type = {Accord.TYPE_PARFAIT,Accord.TYPE_5_DIMINUEE,Accord.TYPE_5_AUGMENTEE,Accord.TYPE_7_DOMINANTE,Accord.TYPE_7_DIMINUEE,Accord.TYPE_7_ESPECE};
	private static final String[] str_styles = {"Plaqu","Arpg","Alatoire"};
	private static final int STYLE_PLAQUE = 0;
	private static final int STYLE_ARPEGE = 1;
	private static final int STYLE_ALEATOIRE = 2;
	private static final int[] correspondance_style = {Accord.STYLE_PLAQUE,Accord.STYLE_ARPEGE,Accord.STYLE_ALEATOIRE};
	private static final String[] str_arpege = {"Montant","Descendant","Alatoire"};
	private static final int ARPEGE_MONTANT = 0;
	private static final int ARPEGE_DESCENDANT = 1;
	private static final int ARPEGE_ALEATOIRE = 2;
	private static final int[] correspondance_arpege = {Accord.STYLE_ARPEGE_MONTANT,Accord.STYLE_ARPEGE_DESCENDANT,Accord.STYLE_ARPEGE_ALEATOIRE};
	private static final String[] str_notes_gardees = {"Gardes","Piques"};
	private static final int NOTES_GARDEES = 0;
	private static final int NOTES_PIQUEES = 1;
	
	public ReconnaissanceAccordsIHM(SolfegeIHM ihm,ReconnaissanceAccords reconnaissance_accords)
	{
		this.ihm = ihm;
		
		this.reconnaissance_accords = reconnaissance_accords;
		reconnaissance_accords.ajouterControleur(this);
		
		console = new Console(ihm);
		console.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e)
			{
				consoleClosed();
			}
		});
		
		chk_tous_types = new JCheckBox("Tous types d'accord");
		chk_tous_types.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				typeClicked();
			}
		});
		lst_type = new JList(str_types);
		
		chk_notes_doublees = new JCheckBox("Notes doubles");
		
		cmb_style = new JComboBox(str_styles);
		cmb_style.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				styleChanged();
			}
		});

		cmb_arpege = new JComboBox(str_arpege);

		cmb_notes_gardees = new JComboBox(str_notes_gardees);
		cmb_notes_gardees.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				notesGardeesChanged();
			}
		});
		
		spn_nb_notes = new SpinSlider(3,10,1,1);

		spn_tps_gardees = new SpinSlider(1,10,1,1);

		spn_nb_accords = new SpinSlider(1,10,1,3);

		spn_tps_intermediaire = new SpinSlider(1,5,1,1);

		cmb_instruments = new JComboBox(LecteurPartition.getInstruments());

		btn_demarrer = new JButton("Dmarrer le test");
		btn_demarrer.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				demarrerClicked();
			}
		});
		
		BoxLayout layout = new BoxLayout(this,BoxLayout.Y_AXIS);
		this.setLayout(layout);
		
		Box box_type = new Box(BoxLayout.X_AXIS);
		box_type.add(chk_tous_types);
		box_type.add(lst_type);
		add(box_type);
		
		Box box_double = new Box(BoxLayout.X_AXIS);
		box_double.add(chk_notes_doublees);
		add(box_double);
		
		Box box_style = new Box(BoxLayout.X_AXIS);
		box_style.add(new JLabel("Style : "));
		cmb_style.setMaximumSize(cmb_style.getPreferredSize());
		box_style.add(cmb_style);
		box_style.add(new JLabel("Arpg : "));
		cmb_arpege.setMaximumSize(cmb_arpege.getPreferredSize());
		box_style.add(cmb_arpege);
		add(box_style);
		
		Box box_notes = new Box(BoxLayout.X_AXIS);
		box_notes.add(new JLabel("Notes : "));
		cmb_notes_gardees.setMaximumSize(cmb_notes_gardees.getPreferredSize());
		box_notes.add(cmb_notes_gardees);
		box_notes.add(new JLabel("Gardes (s) : "));
		box_notes.add(spn_tps_gardees);
		add(box_notes);

		Box box_nb_notes = new Box(BoxLayout.X_AXIS);
		box_nb_notes.add(new JLabel("Nombre de notes par accord : "));
		box_nb_notes.add(spn_nb_notes);
		add(box_nb_notes);
		
		Box box_lecture = new Box(BoxLayout.X_AXIS);
		box_lecture.add(new JLabel("Nombre d'accords par srie : "));
		box_lecture.add(spn_nb_accords);
		add(box_lecture);

		Box box_lecture2 = new Box(BoxLayout.X_AXIS);
		box_lecture2.add(new JLabel("Temps entre chaque accord (s) : "));
		box_lecture2.add(spn_tps_intermediaire);
		add(box_lecture2);

		Box box_instruments = new Box(BoxLayout.X_AXIS);
		box_instruments.add(new JLabel("Instrument : "));
		cmb_instruments.setMaximumSize(cmb_instruments.getPreferredSize());
		box_instruments.add(cmb_instruments);
		add(box_instruments);
		
		Box box_btn = new Box(BoxLayout.X_AXIS);
		box_btn.add(btn_demarrer);
		add(box_btn);
	}
	
	protected void typeClicked()
	{
		lst_type.setEnabled(chk_tous_types.isSelected() == false);
	}
	
	protected void consoleClosed()
	{
		reconnaissance_accords.arreterLecture();
		int r = JOptionPane.showConfirmDialog(this,"Le test a t interrompu. Voulez-vous voir la solution ?","Solfege",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE);
		if(r == JOptionPane.YES_OPTION)
		{
			afficherSolution();
		}
	}
	
	protected void styleChanged()
	{
		cmb_arpege.setEnabled(cmb_style.getSelectedIndex() != STYLE_PLAQUE);
	}
	
	protected void notesGardeesChanged()
	{
		spn_tps_gardees.setEnabled(cmb_notes_gardees.getSelectedIndex() != NOTES_PIQUEES);
	}
	
	protected void demarrerClicked()
	{
		int nb_accords = spn_nb_accords.getValue();
		int style = correspondance_style[cmb_style.getSelectedIndex()];
		int style_arpege = correspondance_arpege[cmb_arpege.getSelectedIndex()];
		int types = Accord.TYPE_NONE;
		if(chk_tous_types.isSelected())
			types = Accord.TYPE_ALL;
		else
		{
			int[] sel = lst_type.getSelectedIndices();
			for(int i : sel)
				types |= correspondance_type[i];
		}
		if(types == Accord.TYPE_NONE)
		{
			JOptionPane.showMessageDialog(this,"Veuillez slectionner au moins un type d'accord","Solfge - Erreur",JOptionPane.ERROR_MESSAGE);
			return;
		}
		int nb_notes = spn_nb_notes.getValue();
		int tps_attente = spn_tps_intermediaire.getValue();
		int tps_notes_gardees = spn_tps_gardees.getValue();
		if(cmb_notes_gardees.getSelectedIndex() == NOTES_PIQUEES)
		{
			tps_notes_gardees = SerieAccords.NOTES_PIQUEES;
		}
		
		console.setVisible(true);
		console.ajouterTexte("Gnration de la srie d'accords...");
		reconnaissance_accords.genererSerie(nb_accords,tps_attente,tps_notes_gardees,types,style,style_arpege,nb_notes);
		console.ajouterTexte("OK\n");
		
		lireSerie();
	}
	
	protected void lireSerie()
	{
		Instrument instrument = (Instrument)cmb_instruments.getSelectedItem();
		
		reconnaissance_accords.jouerSerie(instrument);
	}
	
	public void afficherSolution()
	{
		DessinSerieAccordsDialog dessin = new DessinSerieAccordsDialog(ihm,"Solfge - Solution",true,reconnaissance_accords.getSerie()); 
		dessin.setVisible(true);
	}
	
	public void signaler(EvenementSerieAccords e) {
		switch(e.getType())
		{
		case EvenementSerieAccords.ACCORD_LU:
		{
			EvenementAccordLu ev = (EvenementAccordLu)e;
			console.ajouterTexte("Lecture de l'accord " + ev.getNum() + "/" + ev.getNb() + "\n");
		}
		break;
		
	case EvenementSerieAccords.ACCORD_FINI:
		break;
		
	case EvenementSerieAccords.SERIE_LUE:
		console.ajouterTexte("Lecture de la srie\n");
		break;
		
	case EvenementSerieAccords.SERIE_FINIE:
		console.setVisible(false);
		String[] actions = {"Voir la solution","Refaire le test"}; 
		Object r;
		do
		{
			r = JOptionPane.showInputDialog(this,"Le test est fini, dsirez-vous voir la solution, ou refaire le test une nouvelle fois ?","Solfege",JOptionPane.QUESTION_MESSAGE,null,actions,actions[0]);
			if(r != null)
			{
				if(r.equals(actions[0]))
				{
					afficherSolution();
				}
				else if(r.equals(actions[1]))
				{
					console.setVisible(true);
					lireSerie();
				}
			}
		}while(r != null && r.equals(actions[0]));
		break;
	
		case EvenementSerieAccords.MIDI_NON_SUPPORTE:
			JOptionPane.showMessageDialog(this,"Les fonctions MIDI sont indisponibles sur cette machine !","Solfege - Erreur",JOptionPane.ERROR_MESSAGE);
			break;
			
		default:
			console.ajouterTexte("vnement : " + e.getType() + "\n");
			break;
		}
	}
	
	public void loadPreferences(Preferences preferences)
	{
		ByteArrayInputStream stream = new ByteArrayInputStream(preferences.getByteArray("types",new byte[0]));
		try
		{
			ObjectInputStream object_stream = new ObjectInputStream(stream);
			int[] indices = (int[])object_stream.readObject();
			lst_type.setSelectedIndices(indices);
		}catch(Exception e){}
		chk_tous_types.setSelected(preferences.getBoolean("tous_types",true));
		chk_notes_doublees.setSelected(preferences.getBoolean("notes_doublees",false));
		cmb_style.setSelectedIndex(preferences.getInt("style",0));
		cmb_arpege.setSelectedIndex(preferences.getInt("arpege",0));
		cmb_notes_gardees.setSelectedIndex(preferences.getInt("notes_gardees",0));
		spn_nb_notes.setValue(preferences.getInt("nb_notes",5));
		spn_tps_gardees.setValue(preferences.getInt("tps_gardees",3));
		spn_nb_accords.setValue(preferences.getInt("nb_accords",5));
		spn_tps_intermediaire.setValue(preferences.getInt("tps_intermediaire",2));
		cmb_instruments.setSelectedIndex(preferences.getInt("instrument_index",0));
	}
	
	public void savePreferences(Preferences preferences)
	{
		preferences.putBoolean("tous_types",chk_tous_types.isSelected());
		int[] indices = lst_type.getSelectedIndices();
		ByteArrayOutputStream stream = new ByteArrayOutputStream();
		try
		{
			ObjectOutputStream object_stream = new ObjectOutputStream(stream); 
			object_stream.writeObject(indices);
			preferences.putByteArray("types",stream.toByteArray());
		}catch(IOException e) {}
		preferences.putBoolean("notes_doublees",chk_notes_doublees.isSelected());
		preferences.putInt("style",cmb_style.getSelectedIndex());
		preferences.putInt("arpege",cmb_arpege.getSelectedIndex());
		preferences.putInt("notes_gardees",cmb_notes_gardees.getSelectedIndex());
		preferences.putInt("nb_notes",spn_nb_notes.getValue());
		preferences.putInt("tps_gardees",spn_tps_gardees.getValue());
		preferences.putInt("nb_accords",spn_nb_accords.getValue());
		preferences.putInt("tps_intermediaire",spn_tps_intermediaire.getValue());
		preferences.putInt("instrument_index",cmb_instruments.getSelectedIndex());
	}
}
