import java.util.ArrayList;
import java.util.Random;
import javax.sound.midi.Instrument;

public class ReconnaissanceAccords implements SerieAccordsControleur {

	private SerieAccords serie;
	private ArrayList<SerieAccordsControleur> controleurs;
	private LecteurSerieAccords lecteur;
	
	private static int[] types_mask = {Accord.TYPE_PARFAIT,Accord.TYPE_7_DOMINANTE,Accord.TYPE_7_DIMINUEE,Accord.TYPE_7_ESPECE,Accord.TYPE_5_DIMINUEE,Accord.TYPE_5_AUGMENTEE};
	
	public ReconnaissanceAccords()
	{
		serie = null;
		controleurs = new ArrayList<SerieAccordsControleur>();
		lecteur = new LecteurSerieAccords();
		lecteur.ajouterControleur(this);
	}
	
	public void genererSerie(int nb_accords,int tps_attente,int tps_notes_gardees,int types,int style,int style_arpege,int nb_notes)
	{
		Random rand = new Random();
		
		int nb_types = 0;
		int[] cur_types_mask = new int[6];
		for(int mask : types_mask)
		{
			if((types & mask) != 0)
				cur_types_mask[nb_types++] = mask;
		}

		Accord[] accords = new Accord[nb_accords];
		for(int i = 0 ; i < nb_accords ; i++)
		{
			int type = cur_types_mask[rand.nextInt(nb_types)];
			int basse = Element.noteAleatoire(); // TO FIX
			accords[i] = new Accord(type,style,style_arpege,nb_notes,basse);
		}

		serie = new SerieAccords(accords,tps_attente,tps_notes_gardees);
	}
	
	public void jouerSerie(Instrument instrument)
	{
		if(serie == null)
			return;
		
		lecteur.charger(serie);
		lecteur.lire(instrument);
	}
	
	public void arreterLecture()
	{
		lecteur.arreter();
	}
	
	public SerieAccords getSerie()
	{
		return serie;
	}
	
	public void ajouterControleur(SerieAccordsControleur controleur)
	{
		controleurs.add(controleur);
	}
	
	public void signaler(EvenementSerieAccords e) {
		for(SerieAccordsControleur controleur : controleurs)
			controleur.signaler(e);
	}

}
