import java.util.ArrayList;

// Todo : grer les mesures

public class Partition {

	/**
	 * @uml.property  name="nb_voies" readOnly="true"
	 */
	private int nb_voies;

	/** 
	 * @uml.property name="voie"
	 * @uml.associationEnd multiplicity="(0 -1)" dimension="1" ordering="true" aggregation="composite" inverse="partition:Voie"
	 */
	private ArrayList<Voie> voies;

	/**
	 */
	public Partition(){
		nb_voies = 0;
		voies = new ArrayList<Voie>();
	}

	public Voie[] getVoies()
	{
		Voie[] foo = new Voie[0];
		return voies.toArray(foo);
	}

	/**
	 */
	public Voie creerVoie(){
		Voie voie = new Voie();
		voies.add(voie);
		nb_voies++;
		return voie;
	}

	/**
	 * Getter of the property <tt>nb_voies</tt>
	 * @return  Returns the nb_voies.
	 * @uml.property  name="nb_voies"
	 */
	public int getNbVoies() {
		return nb_voies;
	}
	
	public int getLongueur()
	{
		int longueur = 0;
		for(Voie voie : voies)
			longueur = Math.max(longueur,voie.getLongueur());

		return longueur;
	}
	
	public int getNbNotes()
	{
		int nb = 0;
		for(Voie voie : voies)
			nb = Math.max(nb,voie.getNbNotes());
		
		return nb;
	}
	
	static Partition creerPartitionLa()
	{
		Partition partition_la = new Partition();
		Voie voie = partition_la.creerVoie();
		voie.ajouter(Element.LA3,Element.BLANCHE); // La du diapason
		voie.ajouter(Element.SILENCE,Element.NOIRE);
		return partition_la;
	}
}
