import java.util.ArrayList;
import javax.sound.midi.*;

public class LecteurSerieIntervalles implements Runnable {
	
	private ArrayList<SerieIntervallesControleur> controleurs;
	SerieIntervalles serie;
	Instrument instrument;

	private int thread_etat;
	private static final int ETAT_MORT = 0;
	private static final int ETAT_EXECUTE = 1;
	private static final int ETAT_SUSPENDU = 2;
	
	public LecteurSerieIntervalles()
	{
		controleurs = new ArrayList<SerieIntervallesControleur>();
		setEtatThread(ETAT_MORT);
	}
	
	public void charger(SerieIntervalles serie)
	{
		this.serie = serie;
	}
	
	public void lire(Instrument instrument)
	{
		if(serie == null)
		{
			signaler(new EvenementSerieIntervalles(EvenementSerieIntervalles.PAS_DE_SERIE));
			return;
		}
		
		this.instrument = instrument;
		
		Thread thread = new Thread(this);
		thread.start();
	}
	
	public void suspendre()
	{
		int etat = getEtatThread();
		if(etat == ETAT_EXECUTE)
			setEtatThread(ETAT_SUSPENDU);
		else if(etat == ETAT_SUSPENDU)
			setEtatThread(ETAT_EXECUTE);
	}
	
	public void arreter()
	{
		setEtatThread(ETAT_MORT);
	}
	
	public void run()
	{
		MidiChannel channel;
		Synthesizer synth;

		setEtatThread(ETAT_EXECUTE);
		signaler(new EvenementSerieIntervalles(EvenementSerieIntervalles.SERIE_LUE));

		try
		{
			synth = MidiSystem.getSynthesizer();
			synth.open();
			channel = synth.getChannels()[0];
			channel.allSoundOff();
			channel.programChange(instrument.getPatch().getBank(),instrument.getPatch().getProgram());
		}
		catch(Exception exc)
		{
			signaler(new EvenementSerieIntervalles(EvenementSerieIntervalles.MIDI_NON_SUPPORTE));
			return;
		}
		
		int num_intervalle = 0;
		Intervalle[] intervalles = serie.getIntervalles();
		int tps_notes_gardees = serie.getTpsNotesGardees();
		if(tps_notes_gardees == SerieIntervalles.NOTES_PIQUEES)
		{
			tps_notes_gardees = 50;
		}
		
		while(getEtatThread() != ETAT_MORT && num_intervalle < intervalles.length)
		{
			// Lire l'intervalle
			Intervalle intervalle = intervalles[num_intervalle];
			
			signaler(new EvenementIntervalleLu(num_intervalle + 1,intervalles.length));
			switch(intervalle.getStyle())
			{
			case Intervalle.STYLE_PLAQUE:
				channel.noteOn(intervalle.getNote1() + Element.OFFSET_TO_MIDI,63);
				channel.noteOn(intervalle.getNote2() + Element.OFFSET_TO_MIDI,63);
				try {
					Thread.sleep(tps_notes_gardees);
				}catch(Exception e) {}
				channel.noteOff(intervalle.getNote1() + Element.OFFSET_TO_MIDI,63);
				channel.noteOff(intervalle.getNote2() + Element.OFFSET_TO_MIDI,63);
				break;
				
			case Intervalle.STYLE_ARPEGE:
				channel.noteOn(intervalle.getNote1() + Element.OFFSET_TO_MIDI,63);
				try {
					Thread.sleep(tps_notes_gardees);
				}catch(Exception e) {}
				channel.noteOff(intervalle.getNote1() + Element.OFFSET_TO_MIDI,63);
				channel.noteOn(intervalle.getNote2() + Element.OFFSET_TO_MIDI,63);
				try {
					Thread.sleep(tps_notes_gardees);
				}catch(Exception e) {}
				channel.noteOff(intervalle.getNote2() + Element.OFFSET_TO_MIDI,63);
				break;
			}
			signaler(new EvenementSerieIntervalles(EvenementSerieIntervalles.INTERVALLE_FINI));
			
			try
			{
				Thread.sleep(serie.getTpsAttente() * 1000);
			}
			catch(Exception e) {}
			
			num_intervalle++;
		}
		
		synth.close();
		
		if(num_intervalle == intervalles.length)
			signaler(new EvenementSerieIntervalles(EvenementSerieIntervalles.SERIE_FINIE));
	}

	protected void signaler(EvenementSerieIntervalles e){
		for(SerieIntervallesControleur controleur: controleurs)
			controleur.signaler(e);
	}

	public void ajouterControleur(SerieIntervallesControleur controleur){
		controleurs.add(controleur);
	}

	private synchronized void setEtatThread(int etat)
	{
		thread_etat = etat;
	}
	
	private synchronized int getEtatThread()
	{
		return thread_etat;
	}
}
