import java.util.ArrayList;
import javax.sound.midi.*;


public class LecteurSerieAccords implements Runnable {

	private ArrayList<SerieAccordsControleur> controleurs;
	private SerieAccords serie;
	private Instrument instrument;
	
	private int thread_etat;
	private static final int ETAT_MORT = 0;
	private static final int ETAT_EXECUTE = 1;
	private static final int ETAT_SUSPENDU = 2;
	
	public LecteurSerieAccords()
	{
		controleurs = new ArrayList<SerieAccordsControleur>();
		serie = null;
	}
	
	public void charger(SerieAccords serie)
	{
		this.serie = serie;
	}
	
	public void lire(Instrument instrument)
	{
		if(serie == null)
		{
			signaler(new EvenementSerieAccords(EvenementSerieAccords.PAS_DE_SERIE));
			return;
		}
		
		this.instrument = instrument;
		
		Thread thread = new Thread(this);
		thread.start();
	}
	
	public void suspendre()
	{
		int etat = getEtatThread();
		if(etat == ETAT_EXECUTE)
			setEtatThread(ETAT_SUSPENDU);
		else if(etat == ETAT_SUSPENDU)
			setEtatThread(ETAT_EXECUTE);
	}
	
	public void arreter()
	{
		setEtatThread(ETAT_MORT);
	}
	
	public void run() {
		MidiChannel channel;
		Synthesizer synth;

		setEtatThread(ETAT_EXECUTE);
		signaler(new EvenementSerieAccords(EvenementSerieAccords.SERIE_LUE));

		try
		{
			synth = MidiSystem.getSynthesizer();
			synth.open();
			channel = synth.getChannels()[0];
			channel.allSoundOff();
			channel.programChange(instrument.getPatch().getBank(),instrument.getPatch().getProgram());
		}
		catch(Exception exc)
		{
			signaler(new EvenementSerieAccords(EvenementSerieAccords.MIDI_NON_SUPPORTE));
			return;
		}
		
		int num_accord = 0;
		Accord[] accords = serie.getAccords();
		int tps_notes_gardees = serie.getTpsNotesGardees();
		if(tps_notes_gardees == SerieAccords.NOTES_PIQUEES)
		{
			tps_notes_gardees = 1;
		}
		
		while(getEtatThread() != ETAT_MORT && num_accord < accords.length)
		{
			// Lire l'intervalle
			Accord accord = accords[num_accord];
			
			signaler(new EvenementAccordLu(num_accord + 1,accords.length));

			int[] notes = accord.getNotes();
			int i = 0;

			switch(accord.getStyle())
			{
			case Accord.STYLE_ARPEGE_MONTANT:
			case Accord.STYLE_ARPEGE_DESCENDANT:
				while(getEtatThread() != ETAT_MORT && i < notes.length)
				{
					channel.noteOn(notes[i] + Element.OFFSET_TO_MIDI,63);
					try{
						Thread.sleep(tps_notes_gardees * 1000);
					}catch(Exception e) {}
					channel.noteOff(notes[i] + Element.OFFSET_TO_MIDI,63);
					i++;
				}
				break;

			case Accord.STYLE_PLAQUE:
				// Lecture des notes
				while(getEtatThread() != ETAT_MORT && i < notes.length)
				{
					channel.noteOn(notes[i] + Element.OFFSET_TO_MIDI,63);
					i++;
				}
				try{
					Thread.sleep(tps_notes_gardees * 1000);
				}catch(Exception e) {}
				channel.allNotesOff();
				break;
			}

			signaler(new EvenementSerieAccords(EvenementSerieAccords.ACCORD_FINI));
			
			try
			{
				Thread.sleep(serie.getTpsAttente() * 1000);
			}
			catch(Exception e) {}
			
			num_accord++;
		}
		
		synth.close();
		
		if(num_accord == accords.length)
			signaler(new EvenementSerieAccords(EvenementSerieAccords.SERIE_FINIE));
	}

	public void ajouterControleur(SerieAccordsControleur controleur){
		controleurs.add(controleur);
	}
	
	protected void signaler(EvenementSerieAccords e)
	{
		for(SerieAccordsControleur controleur : controleurs)
			controleur.signaler(e);
	}

	private synchronized void setEtatThread(int etat)
	{
		thread_etat = etat;
	}
	
	private synchronized int getEtatThread()
	{
		return thread_etat;
	}
}
