import javax.sound.midi.*;
import java.util.ArrayList;

public class LecteurPartition implements Runnable {

	/**
	 * @uml.property  name="partition"
	 * @uml.associationEnd  inverse="lecteurPartition:Partition"
	 */
	private Partition partition;
	
	private Instrument instrument;
	private int tempo;
	private Thread thread;
	int thread_etat;
	private static final int ETAT_MORT = 0;
	private static final int ETAT_EXECUTE = 1;
	private static final int ETAT_SUSPENDU = 2;

	/**
	 * @uml.property  name="controleurs"
	 * @uml.associationEnd  multiplicity="(0 -1)" dimension="1" ordering="true" inverse="lecteurPartition:MusiqueControleur"
	 */
	private ArrayList<MusiqueControleur> controleurs;

	/**
	 */
	public LecteurPartition()
	{
		controleurs = new ArrayList<MusiqueControleur>();
		instrument = null;
		tempo = 60;
		thread = null;
	}

	/**
	 */
	public void charger(Partition partition){
		this.partition = partition;
	}

	/**
	 */
	public void lire(Instrument instrument,int tempo){
		if(partition == null)
		{
			signaler(new EvenementMusique(EvenementMusique.PAS_DE_PARTITION));
			return;
		}
		this.instrument = instrument;
		this.tempo = tempo;
		thread = new Thread(this);
		thread.start();
	}

	/**
	 */
	public void suspendre(){
		if(getEtatThread() == ETAT_SUSPENDU)
		{
			setEtatThread(ETAT_EXECUTE);
		}
		else
		{
			setEtatThread(ETAT_SUSPENDU);
		}
	}
	
	/**
	 */
	public void arreter(){
		setEtatThread(ETAT_MORT);
	}
	
	private synchronized void setEtatThread(int etat)
	{
		thread_etat = etat;
	}
	
	private synchronized int getEtatThread()
	{
		return thread_etat;
	}

	/**
	 * Lit la partition
	 */
	public void run()
	{
		MidiChannel channel;
		Synthesizer synth;

		setEtatThread(ETAT_EXECUTE);

		try
		{
			synth = MidiSystem.getSynthesizer();
			synth.open();
			channel = synth.getChannels()[0];
			channel.allSoundOff();
			channel.programChange(instrument.getPatch().getBank(),instrument.getPatch().getProgram());
		}
/*		catch(MidiUnavailableException e)
		{
			signaler(new EvenementMidiIndisponible());
			return;
		}
		catch(IndexOutOfBoundsException ex)
		{
			signaler(new EvenementMidiIndisponible());
			return;
		}*/
		catch(Exception exc)
		{
			signaler(new EvenementMidiIndisponible());
			return;
		}

		final int nb_voies = partition.getNbVoies();
		int nb_voies_finies = 0;
		Voie.Iterateur[] voies = new Voie.Iterateur[nb_voies];
		Voie[] v = partition.getVoies();
		int temps = 0; // Unit : dure d'une double croche
		
		for(int i = 0 ; i < nb_voies ; i++)
		{
			voies[i] = v[i].iterateur();
		}
		
		signaler(new EvenementMusique(EvenementMusique.PARTITION_LUE));
		
		do
		{
			for(int i = 0 ; i < nb_voies ; i++)
			{
				if(voies[i].elementDisponible())
				{
					Element e = voies[i].elementCourant();
					if(e.getPosition() + e.getDuree() == temps)
					{
						if(e.getType() != Element.SILENCE)
						{
							channel.noteOff(e.getType() + Element.OFFSET_TO_MIDI,63);
						}
						voies[i].elementSuivant();
						if(!voies[i].elementDisponible())
						{
							nb_voies_finies ++;
							continue;
						}
					}
					e = voies[i].elementCourant();
					if(e.getPosition() == temps)
					{
						if(e.getType() != Element.SILENCE)
						{
							channel.noteOn(e.getType() + Element.OFFSET_TO_MIDI,63);
						}
					}
				}
			}
			temps++;
			try
			{
				Thread.sleep(60*1000/(tempo*4)); // A synchroniser avec le tempo,  ajuster avec le temps de traitement
			}
			catch(InterruptedException e)
			{
				
			}
		}while(nb_voies_finies < nb_voies && getEtatThread() == ETAT_EXECUTE);
		
		synth.close();
		if(nb_voies_finies == nb_voies)
			signaler(new EvenementMusique(EvenementMusique.PARTITION_FINIE));
	}
	
	/**
	 */
	public static Instrument[] getInstruments()
	{
		try
		{
			Synthesizer s = MidiSystem.getSynthesizer();
			s.open();
			return s.getAvailableInstruments();
		}
		catch(MidiUnavailableException e)
		{
			return new Instrument[0];
		}
	}

		
	/**
	 */
	protected void signaler(EvenementMusique e){
		for(MusiqueControleur controleur: controleurs)
			controleur.signaler(e);
	}

	/**
	 */
	public void ajouterControleur(MusiqueControleur controleur){
		controleurs.add(controleur);
	}
}
