import java.util.Random;

public class Intervalle {

	private int note1;
	private int note2;
	private int style;
	
	public Intervalle(int ecart,int note_base,int style,int style_arpege)
	{
		Random rand = new Random();
		
		if(style == STYLE_ALEATOIRE)
			style = rand.nextInt(2);

		switch(style)
		{
		case STYLE_ARPEGE:
			if(style_arpege == STYLE_ARPEGE_ALEATOIRE)
				style_arpege = rand.nextBoolean()?STYLE_ARPEGE_MONTANT:STYLE_ARPEGE_DESCENDANT;
			switch(style_arpege)
			{
			case STYLE_ARPEGE_MONTANT:
				{
					note1 = note_base;
					note2 = note_base + ecart;
				}
				break;
				
			case STYLE_ARPEGE_DESCENDANT:
				{
					note2 = note_base;
					note1 = note_base + ecart;
				}
				break;
			}
			break;
			
		case STYLE_PLAQUE:
			{
				note1 = note_base;
				note2 = note_base + ecart;
			}
			break;
		}
		
		this.style = style;
	}
	
	public int getEcart()
	{
		return Math.abs(note1 - note2);
	}
	
	public int getNote1()
	{
		return note1;
	}
	
	public int getNote2()
	{
		return note2;
	}
	
	public int getStyle()
	{
		return style;
	}
	
	public String toString()
	{
		String result = "";
		int ecart = Math.abs(note2 - note1);
		int nb_octaves = ecart / 12;
		int reste = ecart % 12;
		if(nb_octaves != 0 && reste != 0)
			result += nb_octaves + " octave" + (nb_octaves > 1?"s":"") + " + ";
		result += str_ecarts[reste];
		return result;
	}
	
	public static Intervalle intervalleAleatoire(int style,int style_arpege,boolean sauts_octave)
	{
		Random rand = new Random();
		int ecart_max = sauts_octave?Element.NB_NOTES - 1:12;
		int ecart = rand.nextInt(ecart_max) + 1;
		int note_base = rand.nextInt(Element.NB_NOTES - ecart);

		return new Intervalle(ecart,note_base,style,style_arpege);
	}
	
	public static final int STYLE_PLAQUE = 0;
	public static final int STYLE_ARPEGE = 1;
	public static final int STYLE_ARPEGE_MONTANT = 2;
	public static final int STYLE_ARPEGE_DESCENDANT = 3;
	public static final int STYLE_ALEATOIRE = 4;
	public static final int STYLE_ARPEGE_ALEATOIRE = 5;
	
	public static final String[] str_ecarts = {
		"Octave",
		"Seconde mineure", // 1/2 ton
		"Seconde majeure",
		"Tierce mineure",
		"Tierce majeure",
		"Quarte juste",
		"Quarte augmente",
		"Quinte juste",
		"Sixte mineure",
		"Sixte majeure",
		"Septime mineure",
		"Septime majeure"
	};
	
	public static final int SECONDE_MINEURE = 1;
	public static final int SECONDE_MAJEURE = 2;
	public static final int TIERCE_MINEURE = 3;
	public static final int TIERCE_MAJEURE = 4;
	public static final int QUARTE_JUSTE = 5;
	public static final int QUARTE_AUGMENTEE = 6;
	public static final int QUINTE_JUSTE = 7;
	public static final int SIXTE_MINEURE = 8;
	public static final int SIXTE_MAJEURE = 9;
	public static final int SEPTIEME_MINEURE = 10;
	public static final int SEPTIEME_MAJEURE = 11;
	public static final int OCTAVE = 12;
}
