

import java.util.ArrayList;
import javax.sound.midi.*;

public class DicteeNotes implements MusiqueControleur {

	/** 
	 * @uml.property name="partition"
	 * @uml.associationEnd readOnly="true" inverse="dicteeNotes:Partition"
	 */
	private Partition partition;

	/**
	 * @uml.property  name="controleurs"
	 * @uml.associationEnd  multiplicity="(0 -1)" dimension="1" ordering="true" inverse="dicteeNotes:MusiqueControleur"
	 */
	private ArrayList<MusiqueControleur> controleurs;
	private LecteurPartition lecteur;


	/**
	 */
	public DicteeNotes(){
		controleurs = new ArrayList<MusiqueControleur>();
		partition = null;
		lecteur = new LecteurPartition();
		lecteur.ajouterControleur(this);
	}



	public void genererDictee(int longueur, boolean sauts_octave){
		partition = new Partition();
		Voie voie = partition.creerVoie();
		
		int previous = 12 * 2;
		for(int i = 0 ; i < longueur ; i++)
		{
			int type;
			type = Element.noteAleatoire(previous,sauts_octave);
//			System.out.println("" + type + " ");
			int duree = Element.NOIRE;
			voie.ajouter(type,duree);
			previous = type;
		}
	}

	public void jouerDictee(Instrument instrument,int tempo){
		lecteur.charger(partition);
		lecteur.lire(instrument,tempo);
	}
	
	public void arreterLecture()
	{
		lecteur.arreter();
	}

			
	/**
	 */
	public void ajouterControleur(MusiqueControleur controleur){
		controleurs.add(controleur);
	}

	/**
	 */
	public void signaler(EvenementMusique evenement){
		for(MusiqueControleur controleur: controleurs){
			controleur.signaler(evenement);
		}
			
	}


	/** 
	 * Getter of the property <tt>partition</tt>
	 * @return  Returns the partition.
	 * @uml.property  name="partition"
	 */
	public Partition getPartition() {
		return partition;
	}
}
