import java.util.ArrayList;
import javax.sound.midi.*;


public class DicteeAgregats implements AgregatControleur {

	private ArrayList<AgregatControleur> controleurs;
	private LecteurAgregat lecteur;
	Agregat agregat;
	
	public DicteeAgregats()
	{
		controleurs = new ArrayList<AgregatControleur>();
		lecteur = new LecteurAgregat();
		lecteur.ajouterControleur(this);
		agregat = null;
	}
	
	public void genererAgregat(int nb_notes,int duree)
	{
		Element[] notes = new Element[nb_notes];
		for(int i = 0 ; i < nb_notes ; i++)
			notes[i] = new Element(0,Element.NOIRE,Element.noteAleatoire());
		
		agregat = new Agregat(notes,duree);
	}

	public void jouerAgregat(Instrument instrument)
	{
		if(agregat == null)
			return;
		
		lecteur.charger(agregat);
		lecteur.lire(instrument);
	}
	
	public void arreterLecture()
	{
		lecteur.arreter();
	}
	
	public Agregat getAgregat()
	{
		return agregat;
	}
	
	public void signaler(EvenementAgregat e)
	{
		for(AgregatControleur c : controleurs)
			c.signaler(e);
	}
	
	public void ajouterControleur(AgregatControleur controleur)
	{
		controleurs.add(controleur);
	}
}
