import java.awt.*;
import java.awt.image.BufferedImage;
import javax.swing.*;

public class DessineurPartition extends JComponent {

	private static final int LARGEUR_NOTE = 32;
	private static final int LARGEUR_CLE = 60;
	private static final int HAUTEUR_INTERLIGNE = 10;
	private static final int HAUTEUR_MARGE = 4 * HAUTEUR_INTERLIGNE; 
	private static final int HAUTEUR = HAUTEUR_INTERLIGNE * 4 * 2 + HAUTEUR_MARGE * 3;
	private static final int HAUTEUR_QUEUE = 30;
	
	private static final int y_pos[] = {
		HAUTEUR - HAUTEUR_MARGE + HAUTEUR_INTERLIGNE * 2, // DO1
		HAUTEUR - HAUTEUR_MARGE + HAUTEUR_INTERLIGNE * 2, // DOD1
		HAUTEUR - HAUTEUR_MARGE + (HAUTEUR_INTERLIGNE * 3) / 2, // RE1
		HAUTEUR - HAUTEUR_MARGE + (HAUTEUR_INTERLIGNE * 3) / 2, // RED1
		HAUTEUR - HAUTEUR_MARGE + HAUTEUR_INTERLIGNE, // MI1
		HAUTEUR - HAUTEUR_MARGE + HAUTEUR_INTERLIGNE / 2, // FA1
		HAUTEUR - HAUTEUR_MARGE + HAUTEUR_INTERLIGNE / 2, // FAD1
		HAUTEUR - HAUTEUR_MARGE, // SOL1
		HAUTEUR - HAUTEUR_MARGE, // SOLD1
		HAUTEUR - HAUTEUR_MARGE - HAUTEUR_INTERLIGNE / 2, // LA1
		HAUTEUR - HAUTEUR_MARGE - HAUTEUR_INTERLIGNE / 2, // LAD1
		HAUTEUR - HAUTEUR_MARGE - HAUTEUR_INTERLIGNE, // SI1
		HAUTEUR - HAUTEUR_MARGE - (HAUTEUR_INTERLIGNE * 3) / 2, // DO2
		HAUTEUR - HAUTEUR_MARGE - (HAUTEUR_INTERLIGNE * 3) / 2, // DOD2
		HAUTEUR - HAUTEUR_MARGE - HAUTEUR_INTERLIGNE * 2, // RE2
		HAUTEUR - HAUTEUR_MARGE - HAUTEUR_INTERLIGNE * 2, // RED2
		HAUTEUR - HAUTEUR_MARGE - (HAUTEUR_INTERLIGNE * 5) / 2, // MI2
		HAUTEUR - HAUTEUR_MARGE - HAUTEUR_INTERLIGNE * 3, // FA2
		HAUTEUR - HAUTEUR_MARGE - HAUTEUR_INTERLIGNE * 3, // FAD2
		HAUTEUR - HAUTEUR_MARGE - (HAUTEUR_INTERLIGNE * 7) / 2, // SOL2
		HAUTEUR - HAUTEUR_MARGE - (HAUTEUR_INTERLIGNE * 7) / 2, // SOLD2
		HAUTEUR - HAUTEUR_MARGE - HAUTEUR_INTERLIGNE * 4, // LA2
		HAUTEUR - HAUTEUR_MARGE - HAUTEUR_INTERLIGNE * 4, // LAD2
		HAUTEUR - HAUTEUR_MARGE - (HAUTEUR_INTERLIGNE * 9) / 2, // SI2
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE + HAUTEUR_INTERLIGNE, // DO3 - Affich sur la cl de sol
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE + HAUTEUR_INTERLIGNE, // DOD3
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE + HAUTEUR_INTERLIGNE / 2, // RE3
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE + HAUTEUR_INTERLIGNE / 2, // RED3
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE, // MI3
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - HAUTEUR_INTERLIGNE / 2, // FA3
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - HAUTEUR_INTERLIGNE / 2, // FAD3
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - HAUTEUR_INTERLIGNE , // SOL3
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - HAUTEUR_INTERLIGNE , // SOLD3
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - (HAUTEUR_INTERLIGNE * 3) / 2, // LA3
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - (HAUTEUR_INTERLIGNE * 3) / 2, // LAD3
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - HAUTEUR_INTERLIGNE * 2, // SI3
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - (HAUTEUR_INTERLIGNE * 5) / 2, // DO4
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - (HAUTEUR_INTERLIGNE * 5) / 2, // DOD4
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - HAUTEUR_INTERLIGNE * 3, // RE4
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - HAUTEUR_INTERLIGNE * 3, // RED4
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - (HAUTEUR_INTERLIGNE * 7) / 2, // MI4
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - HAUTEUR_INTERLIGNE * 4, // FA4
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - HAUTEUR_INTERLIGNE * 4, // FAD4
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - (HAUTEUR_INTERLIGNE * 9) / 2, // SOL4
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - (HAUTEUR_INTERLIGNE * 9) / 2, // SOLD4
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - HAUTEUR_INTERLIGNE * 5, // LA4
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - HAUTEUR_INTERLIGNE * 5, // LAD4
		HAUTEUR_MARGE + 4 * HAUTEUR_INTERLIGNE - (HAUTEUR_INTERLIGNE * 11) / 2, // SI4
	};
	
	private static int dieses[] = {
		Element.DOD1,
		Element.DOD2,
		Element.DOD3,
		Element.DOD4,
		Element.RED1,
		Element.RED2,
		Element.RED3,
		Element.RED4,
		Element.FAD1,
		Element.FAD2,
		Element.FAD3,
		Element.FAD4,
		Element.SOLD1,
		Element.SOLD2,
		Element.SOLD3,
		Element.SOLD4,
		Element.LAD1,
		Element.LAD2,
		Element.LAD3,
		Element.LAD4
	};
	
	private Image image;
	
	DessineurPartition(Partition partition)
	{
		image = genererImage(partition);
		
		setPreferredSize(new Dimension(image.getWidth(this),image.getHeight(this)));
	}
	
	protected void paintComponent(Graphics g)
	{
		g.drawImage(image,0,0,this);
	}
	
	private Image genererImage(Partition partition)
	{
		int largeur = partition.getNbNotes()*LARGEUR_NOTE + LARGEUR_CLE;
		int hauteur = HAUTEUR;

		BufferedImage image = new BufferedImage(largeur,hauteur,BufferedImage.TYPE_INT_RGB);
		
		Graphics2D g = image.createGraphics();
		
		dessinerPortee(g,partition);
		
		Voie[] voies = partition.getVoies();
		
		for(int i = 0 ; i < voies.length ; i++)
		{
			int x = LARGEUR_CLE;
			
			Voie.Iterateur voie = voies[i].iterateur();
			while(voie.elementDisponible())
			{
				afficherElement(g,x,voie.elementCourant());
				
				voie.elementSuivant();
				x += LARGEUR_NOTE;
			}
		}
		
		return image;
	}
	
	private void dessinerPortee(Graphics2D g,Partition partition)
	{
		int largeur = partition.getLongueur() * LARGEUR_NOTE + LARGEUR_CLE;
		
		g.setColor(Color.white);
		g.fillRect(0,0,largeur,HAUTEUR);
		
//		Image cle_sol = Toolkit.getDefaultToolkit().getImage("cle_sol.png");
//		Image cle_fa = Toolkit.getDefaultToolkit().getImage("cle_fa.png");
		Image cle_sol = new ImageIcon(SolfegeIHM.class.getResource("cle_sol.png")).getImage();
		Image cle_fa = new ImageIcon(SolfegeIHM.class.getResource("cle_fa.png")).getImage();
/*		MediaTracker tracker = new MediaTracker(this);
		tracker.addImage(cle_sol,0);
		tracker.addImage(cle_fa,1);
		try
		{
			tracker.waitForAll();
		}
		catch(InterruptedException e)
		{
			// Tant pis...
		}*/
		
		g.drawImage(cle_sol,2,HAUTEUR_MARGE - 7,25,60,this);
		g.drawImage(cle_fa,2,HAUTEUR - HAUTEUR_MARGE - HAUTEUR_INTERLIGNE * 4 + 2,25,25,this);
		
		g.setColor(Color.black);
		
		for(int i = 0 ; i < 5 ; i++)
		{
			// Cl de sol
			int y_sol = HAUTEUR_MARGE + i*HAUTEUR_INTERLIGNE;
			g.drawLine(0,y_sol,largeur,y_sol);
			
			// Cl de fa
			int y_fa = HAUTEUR_MARGE * 2 + HAUTEUR_INTERLIGNE * 4 + i*HAUTEUR_INTERLIGNE;
			g.drawLine(0,y_fa,largeur,y_fa);
		}
		
		// Todo : Afficher la mesure 
	}
	
	private static void afficherElement(Graphics2D g,int x,Element e)
	{
		g.setColor(Color.black);
		
		if(e.getType() == Element.SILENCE)
			return; // Pour l'instant...

		int y = y_pos[e.getType()];
		
		// Doit-on rajouter des petits traits de porte ?
		// Cas 1 : la note est en haut de la porte cl de sol (LA4,LAD4,SI4)
		if(y < HAUTEUR_MARGE - HAUTEUR_INTERLIGNE / 2)
		{
			g.drawLine(x - LARGEUR_NOTE/4,HAUTEUR_MARGE - HAUTEUR_INTERLIGNE,x + LARGEUR_NOTE/4,HAUTEUR_MARGE - HAUTEUR_INTERLIGNE);
		}
		// Cas  2 : la note est en bas de la porte cl de fa (DO1,DOD1,RE1,RED1,MI)
		else if(y > HAUTEUR - HAUTEUR_MARGE + HAUTEUR_INTERLIGNE / 2)
		{
			g.drawLine(x - LARGEUR_NOTE/4,HAUTEUR - HAUTEUR_MARGE + HAUTEUR_INTERLIGNE,x + LARGEUR_NOTE/4,HAUTEUR - HAUTEUR_MARGE + HAUTEUR_INTERLIGNE);
			if(y > HAUTEUR - HAUTEUR_MARGE + (HAUTEUR_INTERLIGNE * 3) / 2)
			{
				g.drawLine(x - LARGEUR_NOTE/4,HAUTEUR - HAUTEUR_MARGE + HAUTEUR_INTERLIGNE * 2,x + LARGEUR_NOTE/4,HAUTEUR - HAUTEUR_MARGE + HAUTEUR_INTERLIGNE * 2);
			}
		}
		// Cas 3 : la note est en bas de la cl de sol (DO3,DOD3)
		else if(e.getType() == Element.DO3 || e.getType() == Element.DOD3)
		{
			g.drawLine(x - LARGEUR_NOTE/4,HAUTEUR_MARGE + HAUTEUR_INTERLIGNE * 4 + HAUTEUR_INTERLIGNE,x + LARGEUR_NOTE/4,HAUTEUR_MARGE + HAUTEUR_INTERLIGNE * 4 + HAUTEUR_INTERLIGNE);
		}
		
		// Dessin de la note
		switch(e.getDuree())
		{
		case Element.NOIRE:
			// Note
			g.fillOval(x - HAUTEUR_INTERLIGNE / 2,y - HAUTEUR_INTERLIGNE / 2 + 1,HAUTEUR_INTERLIGNE,HAUTEUR_INTERLIGNE - 2);
			// Queue
			g.drawLine(x + HAUTEUR_INTERLIGNE / 2,y,x + HAUTEUR_INTERLIGNE / 2,y - HAUTEUR_QUEUE);
			break;
		}
		
		// Dessin du dise
		boolean is_diese = false;
		for(int diese : dieses)
		{
			if(e.getType() == diese)
				is_diese = true;
		}
		if(is_diese)
		{
			g.drawChars("#".toCharArray(),0,1,x - HAUTEUR_INTERLIGNE - 5,y + 5);
		}
	}
}
