import java.util.Random;

public class Accord {

	private int basse;
	private int nb_notes;
	private int style;
	private int id;
	private int[] notes;
	
	public static final int TYPE_NONE = 0x00;
	public static final int TYPE_PARFAIT = 0x01;
	public static final int TYPE_7_DOMINANTE = 0x02;
	public static final int TYPE_7_DIMINUEE = 0x04;
	public static final int TYPE_7_ESPECE = 0x08;
	public static final int TYPE_5_DIMINUEE = 0x10;
	public static final int TYPE_5_AUGMENTEE = 0x20;
	public static final int TYPE_ALL = 0x0F;
	
	// Accords parfaits
	public static final int ID_ACCORD_PARFAIT_FOND_MINEUR = 0;
	public static final int ID_ACCORD_PARFAIT_FOND_MAJEUR = 1;
	public static final int ID_ACCORD_PARFAIT_1RENV_MINEUR = 2;
	public static final int ID_ACCORD_PARFAIT_1RENV_MAJEUR = 3;
	public static final int ID_ACCORD_PARFAIT_2RENV_MINEUR = 4;
	public static final int ID_ACCORD_PARFAIT_2RENV_MAJEUR = 5;
	// Accords de 7me dominante
	public static final int ID_ACCORD_7_DOM_FOND = 6;
	public static final int ID_ACCORD_7_DOM_1RENV = 7;
	public static final int ID_ACCORD_7_DOM_3RENV = 8;
	public static final int ID_ACCORD_7_DOM_4RENV = 9;
	// Accords de 7me diminue
	public static final int ID_ACCORD_7_DIM = 10;
	// Accords de 7me espce
	public static final int ID_ACCORD_7_ESP_1 = 11;
	public static final int ID_ACCORD_7_ESP_1_1RENV = 12;
	public static final int ID_ACCORD_7_ESP_1_2RENV = 13;
	public static final int ID_ACCORD_7_ESP_1_3RENV = 14;
	public static final int ID_ACCORD_7_ESP_2 = 15;
	public static final int ID_ACCORD_7_ESP_2_1RENV = 16;
	public static final int ID_ACCORD_7_ESP_2_2RENV = 17;
	public static final int ID_ACCORD_7_ESP_2_3RENV = 18;
	public static final int ID_ACCORD_7_ESP_3 = 19;
	public static final int ID_ACCORD_7_ESP_3_1RENV = 20;
	public static final int ID_ACCORD_7_ESP_3_2RENV = 21;
	public static final int ID_ACCORD_7_ESP_3_3RENV = 22;
	// Accords de 5te diminue
	public static final int ID_ACCORD_5_DIM = 23;
	public static final int ID_ACCORD_5_DIM_1RENV = 24;
	public static final int ID_ACCORD_5_DIM_2RENV = 25;
	// Accords de 5te augmente
	public static final int ID_ACCORD_5_AUG = 26;
	
	private static final int nb_notes_min[] = {
		3,3,3,3,3,3, // Accords parfaits
		4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4, // Accords de 7me qqch
		3,3,3,3 // Accords 5te qqch
	};
	
	private static final int NB_ACCORDS = 27;
	

	private static final int NB_ACCORDS_PARFAITS = 6;
	private static final int[] id_accords_parfaits = {0,1,2,3,4,5};
	
	private static final int NB_ACCORDS_7_DOMINANTE = 4;
	private static final int[] id_accords_7_dominante = {6,7,8,9};
	
	private static final int NB_ACCORDS_7_DIMINUEE = 1;
	private static final int[] id_accords_7_diminuee = {10};
	
	private static final int NB_ACCORDS_7_ESPECE = 12;
	private static final int[] id_accords_7_espece = {11,12,13,14,15,16,17,18,19,20,21,22};
	
	private static final int NB_ACCORDS_5_DIMINUEE = 3;
	private static final int[] id_accords_5_diminuee = {23,24,25};
	
	private static final int NB_ACCORDS_5_AUGMENTEE = 1;
	private static final int[] id_accords_5_augmentee = {26};
	
	public Accord(int type,int style,int style_arpege,int nb_notes,int basse)
	{
		Random rand = new Random();
		if(style == STYLE_ALEATOIRE)
			style = rand.nextInt(2);
		if(style == STYLE_ARPEGE)
		{
			if(style_arpege == STYLE_ARPEGE_ALEATOIRE)
				style_arpege = rand.nextBoolean()?STYLE_ARPEGE_MONTANT:STYLE_ARPEGE_DESCENDANT;
			style = style_arpege;
		}
		
		switch(type) // Tout a pourrait tre rduit en utilisant des tableaux, mais pour l'instant, j'ai la flemme
		{
		case TYPE_PARFAIT:
			id = id_accords_parfaits[rand.nextInt(NB_ACCORDS_PARFAITS)];
			break;

		case TYPE_7_DOMINANTE:
			id = id_accords_7_dominante[rand.nextInt(NB_ACCORDS_7_DOMINANTE)];
			break;

		case TYPE_7_DIMINUEE:
			id = id_accords_7_diminuee[rand.nextInt(NB_ACCORDS_7_DIMINUEE)];
			break;

		case TYPE_7_ESPECE:
			id = id_accords_7_espece[rand.nextInt(NB_ACCORDS_7_ESPECE)];
			break;
			
		case TYPE_5_DIMINUEE:
			id = id_accords_5_diminuee[rand.nextInt(NB_ACCORDS_5_DIMINUEE)];
			break;

		case TYPE_5_AUGMENTEE:
			id = id_accords_5_augmentee[rand.nextInt(NB_ACCORDS_5_AUGMENTEE)];
			break;
		}

		buildAccord(id,style,nb_notes,basse);
	}
	
	public Accord(int id,int style,int nb_notes,int basse)
	{
		buildAccord(id,style,nb_notes,basse);
	}
	
	protected void buildAccord(int id,int style,int nb_notes,int basse)
	{
		this.id = id;
		this.style = style;
		this.basse = basse;

		if(nb_notes < nb_notes_min[id])
			nb_notes = nb_notes_min[id];
		
		notes = new int[nb_notes];
		notes[0] = basse;
		this.nb_notes = nb_notes;
		int nb_notes_definies = 1;
		switch(id)
		{
		case ID_ACCORD_PARFAIT_FOND_MINEUR:
			notes[style == STYLE_ARPEGE_DESCENDANT?1:2] = basse + Intervalle.TIERCE_MINEURE;
			notes[style == STYLE_ARPEGE_DESCENDANT?2:1] = basse + Intervalle.QUINTE_JUSTE;
			nb_notes_definies += 2;
			break;

		case ID_ACCORD_PARFAIT_FOND_MAJEUR:
			notes[style == STYLE_ARPEGE_DESCENDANT?2:1] = basse + Intervalle.TIERCE_MAJEURE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:2] = basse + Intervalle.QUINTE_JUSTE;
			nb_notes_definies += 2;
			break;
			
		case ID_ACCORD_PARFAIT_1RENV_MINEUR:
			notes[style == STYLE_ARPEGE_DESCENDANT?2:1] = basse + Intervalle.TIERCE_MAJEURE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:2] = basse + Intervalle.SIXTE_MAJEURE;
			nb_notes_definies += 2;
			break;
			
		case ID_ACCORD_PARFAIT_1RENV_MAJEUR:
			notes[style == STYLE_ARPEGE_DESCENDANT?2:1] = basse + Intervalle.TIERCE_MINEURE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:2] = basse + Intervalle.SIXTE_MINEURE;
			nb_notes_definies += 2;
			break;
			
		case ID_ACCORD_PARFAIT_2RENV_MINEUR:
			notes[style == STYLE_ARPEGE_DESCENDANT?2:1] = basse + Intervalle.QUARTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:2] = basse + Intervalle.SIXTE_MINEURE;
			nb_notes_definies += 2;
			break;
			
		case ID_ACCORD_PARFAIT_2RENV_MAJEUR:
			notes[style == STYLE_ARPEGE_DESCENDANT?2:1] = basse + Intervalle.QUARTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:2] = basse + Intervalle.SIXTE_MAJEURE;
			nb_notes_definies += 2;
			break;

		case ID_ACCORD_7_DOM_FOND:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.TIERCE_MAJEURE;
			notes[2] = basse + Intervalle.QUINTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SEPTIEME_MINEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_DOM_1RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.TIERCE_MINEURE;
			notes[2] = basse + Intervalle.QUARTE_AUGMENTEE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SIXTE_MINEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_DOM_3RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.TIERCE_MINEURE;
			notes[2] = basse + Intervalle.QUARTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SIXTE_MAJEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_DOM_4RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.SECONDE_MAJEURE;
			notes[2] = basse + Intervalle.QUARTE_AUGMENTEE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SIXTE_MAJEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_DIM:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.TIERCE_MINEURE;
			notes[2] = basse + Intervalle.QUARTE_AUGMENTEE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SIXTE_MAJEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_ESP_1:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.TIERCE_MINEURE;
			notes[2] = basse + Intervalle.QUINTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SEPTIEME_MINEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_ESP_1_1RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.TIERCE_MAJEURE;
			notes[2] = basse + Intervalle.QUINTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SIXTE_MAJEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_ESP_1_2RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.TIERCE_MINEURE;
			notes[2] = basse + Intervalle.QUARTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SIXTE_MINEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_ESP_1_3RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.SECONDE_MAJEURE;
			notes[2] = basse + Intervalle.QUARTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SIXTE_MAJEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_ESP_2:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.TIERCE_MAJEURE;
			notes[2] = basse + Intervalle.QUINTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SEPTIEME_MAJEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_ESP_2_1RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.TIERCE_MINEURE;
			notes[2] = basse + Intervalle.QUINTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SIXTE_MINEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_ESP_2_2RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.TIERCE_MAJEURE;
			notes[2] = basse + Intervalle.QUARTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SIXTE_MAJEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_ESP_2_3RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.SECONDE_MINEURE;
			notes[2] = basse + Intervalle.QUARTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SIXTE_MINEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_ESP_3:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.TIERCE_MINEURE;
			notes[2] = basse + Intervalle.QUARTE_AUGMENTEE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SEPTIEME_MINEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_ESP_3_1RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.TIERCE_MINEURE;
			notes[2] = basse + Intervalle.QUINTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SIXTE_MAJEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_ESP_3_2RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.TIERCE_MAJEURE;
			notes[2] = basse + Intervalle.QUARTE_AUGMENTEE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SIXTE_MAJEURE;
			nb_notes_definies += 3;
			break;

		case ID_ACCORD_7_ESP_3_3RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?3:1] = basse + Intervalle.SECONDE_MAJEURE;
			notes[2] = basse + Intervalle.QUARTE_JUSTE;
			notes[style == STYLE_ARPEGE_DESCENDANT?1:3] = basse + Intervalle.SIXTE_MINEURE;
			nb_notes_definies += 3;
			break;
			
		case ID_ACCORD_5_DIM:
			notes[style == STYLE_ARPEGE_DESCENDANT?1:2] = basse + Intervalle.TIERCE_MINEURE;
			notes[style == STYLE_ARPEGE_DESCENDANT?2:1] = basse + Intervalle.QUARTE_AUGMENTEE;
			nb_notes_definies += 2;
			break;
			
		case ID_ACCORD_5_DIM_1RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?1:2] = basse + Intervalle.TIERCE_MINEURE;
			notes[style == STYLE_ARPEGE_DESCENDANT?2:1] = basse + Intervalle.SIXTE_MAJEURE;
			nb_notes_definies += 2;
			break;
			
		case ID_ACCORD_5_DIM_2RENV:
			notes[style == STYLE_ARPEGE_DESCENDANT?1:2] = basse + Intervalle.QUARTE_AUGMENTEE;
			notes[style == STYLE_ARPEGE_DESCENDANT?2:1] = basse + Intervalle.SIXTE_MAJEURE;
			nb_notes_definies += 2;
			break;
			
		case ID_ACCORD_5_AUG:
			notes[style == STYLE_ARPEGE_DESCENDANT?1:2] = basse + Intervalle.TIERCE_MAJEURE;
			notes[style == STYLE_ARPEGE_DESCENDANT?2:1] = basse + Intervalle.SIXTE_MINEURE;
			nb_notes_definies += 2;
			break;
		}
		
		Random rand = new Random();
		
		if(nb_notes_definies < nb_notes)
		{
			for(int i = nb_notes_definies ; i < nb_notes ; i++)
			{
				notes[i] = notes[rand.nextInt(nb_notes_definies - 1) + 1];
			}
		}
	}
	
/*	public int getType()
	{
		return type;
	}*/
	
	public int getStyle()
	{
		return style;
	}
	
	public int getNbNotes()
	{
		return nb_notes;
	}
	
	public int[] getNotes()
	{
		return notes;
	}
	
	public int getBasse()
	{
		return basse;
	}
	
	public int getId()
	{
		return id;
	}
	
	public String toString()
	{
		return str_id_accord[id];
	}
	
	private static final String str_id_accord[] = {
		"Parfait mineur, tat F",
		"Parfait majeur, tat F",
		"Parfait mineur, tat 1",
		"Parfait majeur, tat 1",
		"Parfait mineur, tat 2",
		"Parfait majeur, tat 2",
		"7e dom, tat F",
		"7e dom, tat 1",
		"7e dom, tat 2",
		"7e dom, tat 3",
		"7e dim, tat F",
		"m7, tat F",
		"m7, tat 1",
		"m7, tat 2",
		"m7, tat 3",
		"M7, tat F",
		"M7, tat 1",
		"M7, tat 2",
		"M7, tat 3",
		"1/2 dim, tat F",
		"1/2 dim, tat 1",
		"1/2 dim, tat 2",
		"1/2 dim, tat 3",
		"5te dim, tat F",
		"5te dim, tat 1",
		"5te dim, tat 2",
		"5te augm, tat F"
	};

	public static final int STYLE_PLAQUE = 0;
	public static final int STYLE_ARPEGE = 1;
	public static final int STYLE_ARPEGE_MONTANT = 2;
	public static final int STYLE_ARPEGE_DESCENDANT = 3;
	public static final int STYLE_ALEATOIRE = 4;
	public static final int STYLE_ARPEGE_ALEATOIRE = 5;

	public static Accord[] getAvailableAccords()
	{
		Accord[] accords = new Accord[NB_ACCORDS];
		
		for(int i = 0 ; i < accords.length ; i++)
		{
			accords[i] = new Accord(i,STYLE_ARPEGE_MONTANT,0,Element.DO2);
		}
		
		return accords;
	}
}
